/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.jta.helper.timer;

import java.util.ArrayList;
import java.util.List;
import org.lastaflute.jta.helper.timer.LjtTimeoutLinkedList;
import org.lastaflute.jta.helper.timer.LjtTimeoutTarget;
import org.lastaflute.jta.helper.timer.LjtTimeoutTask;

public class LjtTimeoutManager
implements Runnable {
    protected static final LjtTimeoutManager instance = new LjtTimeoutManager();
    protected Thread thread;
    protected final LjtTimeoutLinkedList timeoutTaskList = new LjtTimeoutLinkedList();

    private LjtTimeoutManager() {
    }

    public static LjtTimeoutManager getInstance() {
        return instance;
    }

    public synchronized void start() {
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this, "Seasar2-TimeoutManager");
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    public synchronized void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop(long timeoutMillis) throws InterruptedException {
        Thread thread = this.thread;
        LjtTimeoutManager ljtTimeoutManager = this;
        synchronized (ljtTimeoutManager) {
            if (thread == null) {
                return true;
            }
            this.thread = null;
        }
        thread.interrupt();
        thread.join(timeoutMillis);
        return !thread.isAlive();
    }

    public synchronized void clear() {
        this.timeoutTaskList.clear();
    }

    public synchronized LjtTimeoutTask addTimeoutTarget(LjtTimeoutTarget timeoutTarget, int timeout, boolean permanent) {
        LjtTimeoutTask task = new LjtTimeoutTask(timeoutTarget, timeout, permanent);
        this.timeoutTaskList.addLast(task);
        if (this.timeoutTaskList.size() == 1) {
            this.start();
        }
        return task;
    }

    public synchronized int getTimeoutTaskCount() {
        return this.timeoutTaskList.size();
    }

    @Override
    public void run() {
        boolean interrupted = false;
        while (true) {
            List<LjtTimeoutTask> expiredTask = this.getExpiredTask();
            for (LjtTimeoutTask task : expiredTask) {
                task.expired();
                if (!task.isPermanent()) continue;
                task.restart();
            }
            if (interrupted || this.thread.isInterrupted() || this.stopIfLeisure()) {
                return;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
    }

    protected synchronized List<LjtTimeoutTask> getExpiredTask() {
        ArrayList<LjtTimeoutTask> expiredTask = new ArrayList<LjtTimeoutTask>();
        try {
            if (this.timeoutTaskList == null || this.timeoutTaskList.isEmpty()) {
                return expiredTask;
            }
        }
        catch (NullPointerException e) {
            return expiredTask;
        }
        for (LjtTimeoutLinkedList.Entry e = this.timeoutTaskList.getFirstEntry(); e != null; e = e.getNext()) {
            LjtTimeoutTask task = (LjtTimeoutTask)e.getElement();
            if (task.isCanceled()) {
                e.remove();
                continue;
            }
            if (task.isStopped() || !task.isExpired()) continue;
            expiredTask.add(task);
            if (task.isPermanent()) continue;
            e.remove();
        }
        return expiredTask;
    }

    protected synchronized boolean stopIfLeisure() {
        try {
            if (this.timeoutTaskList == null || this.timeoutTaskList.isEmpty()) {
                this.thread = null;
                return true;
            }
        }
        catch (NullPointerException e) {
            return true;
        }
        return false;
    }
}

