/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.jta.util;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import org.lastaflute.jta.exception.LjtIllegalStateException;

public abstract class LjtDriverManagerUtil {
    public static void registerDriver(String driverClassName) {
        LjtDriverManagerUtil.registerDriver(LjtDriverManagerUtil.forName(driverClassName));
    }

    protected static Class forName(String className) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            return Class.forName(className, true, loader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to find class: " + className + " loader=" + loader, e);
        }
    }

    public static void registerDriver(Class driverClass) {
        LjtDriverManagerUtil.registerDriver((Driver)LjtDriverManagerUtil.newInstance(driverClass));
    }

    protected static Object newInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Failed to instantiate the class: " + clazz, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Illegal access to the constructor of the class: " + clazz, e);
        }
    }

    public static void registerDriver(Driver driver) {
        try {
            DriverManager.registerDriver(driver);
        }
        catch (SQLException e) {
            throw new LjtIllegalStateException("Failed to register the driver: " + driver, e);
        }
    }

    public static void deregisterDriver(Driver driver) {
        try {
            DriverManager.deregisterDriver(driver);
        }
        catch (SQLException e) {
            throw new LjtIllegalStateException("Failed to deregister the driver: " + driver, e);
        }
    }

    public static synchronized void deregisterAllDrivers() {
        Enumeration<Driver> e = DriverManager.getDrivers();
        while (e.hasMoreElements()) {
            LjtDriverManagerUtil.deregisterDriver(e.nextElement());
        }
    }
}

