/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.util;

import java.util.Collection;
import java.util.Map;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.ContainerConstants;
import org.lastaflute.di.helper.beans.BeanDesc;
import org.lastaflute.di.helper.beans.factory.BeanDescFactory;

public class BindingUtil
implements ContainerConstants {
    protected BindingUtil() {
    }

    public static final boolean isPropertyAutoBindable(Class<?> clazz) {
        return clazz.isInterface() && BindingUtil.isAnywayAutoBindable(clazz);
    }

    public static final boolean isPropertyAutoBindable(Class<?>[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            if (BindingUtil.isPropertyAutoBindable(classes[i])) continue;
            return false;
        }
        return true;
    }

    public static final boolean isFieldAutoBindable(Class<?> clazz) {
        return BindingUtil.isAnywayAutoBindable(clazz);
    }

    protected static boolean isAnywayAutoBindable(Class<?> clazz) {
        return !Object.class.equals(clazz) && !Collection.class.isAssignableFrom(clazz) && !Map.class.isAssignableFrom(clazz);
    }

    public static final boolean isAutoBindableArray(Class<?> clazz) {
        return clazz.isArray() && clazz.getComponentType().isInterface();
    }

    public static BeanDesc getBeanDesc(ComponentDef componentDef, Object component) {
        return BeanDescFactory.getBeanDesc(BindingUtil.getComponentClass(componentDef, component));
    }

    public static Class<?> getComponentClass(ComponentDef componentDef, Object component) {
        Class<?> clazz = componentDef.getConcreteClass();
        return clazz != null ? clazz : component.getClass();
    }
}

