/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.lastaflute.di.exception.IORuntimeException;
import org.lastaflute.di.exception.ResourceNotFoundRuntimeException;
import org.lastaflute.di.util.LdiInputStreamUtil;
import org.lastaflute.di.util.LdiJarFileUtil;
import org.lastaflute.di.util.LdiURLUtil;

public class LdiResourceUtil {
    protected LdiResourceUtil() {
    }

    public static String getResourcePath(String path, String extension) {
        if (extension == null) {
            return path;
        }
        extension = "." + extension;
        if (path.endsWith(extension)) {
            return path;
        }
        return path.replace('.', '/') + extension;
    }

    public static String getResourcePath(Class clazz) {
        return clazz.getName().replace('.', '/') + ".class";
    }

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static URL getResource(String path) {
        return LdiResourceUtil.getResource(path, null);
    }

    public static URL getResource(String path, String extension) throws ResourceNotFoundRuntimeException {
        URL url = LdiResourceUtil.getResourceNoException(path, extension);
        if (url != null) {
            return url;
        }
        throw new ResourceNotFoundRuntimeException(LdiResourceUtil.getResourcePath(path, extension));
    }

    public static URL getResourceNoException(String path) {
        return LdiResourceUtil.getResourceNoException(path, null);
    }

    public static URL getResourceNoException(String path, String extension) {
        return LdiResourceUtil.getResourceNoException(path, extension, Thread.currentThread().getContextClassLoader());
    }

    public static URL getResourceNoException(String path, String extension, ClassLoader loader) {
        if (path == null || loader == null) {
            return null;
        }
        path = LdiResourceUtil.getResourcePath(path, extension);
        return loader.getResource(path);
    }

    public static InputStream getResourceAsStream(String path) {
        return LdiResourceUtil.getResourceAsStream(path, null);
    }

    public static InputStream getResourceAsStream(String path, String extension) {
        URL url = LdiResourceUtil.getResource(path, extension);
        return LdiURLUtil.openStream(url);
    }

    public static InputStream getResourceAsStreamNoException(String path) {
        return LdiResourceUtil.getResourceAsStreamNoException(path, null);
    }

    public static InputStream getResourceAsStreamNoException(String path, String extension) {
        URL url = LdiResourceUtil.getResourceNoException(path, extension);
        if (url == null) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean isExist(String path) {
        return LdiResourceUtil.getResourceNoException(path) != null;
    }

    public static boolean exists(String path) {
        return LdiResourceUtil.getResourceNoException(path) != null;
    }

    public static Properties getProperties(String path) throws IORuntimeException {
        Properties props = new Properties();
        InputStream is = LdiResourceUtil.getResourceAsStream(path);
        try {
            props.load(is);
            Properties properties = props;
            return properties;
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
        finally {
            LdiInputStreamUtil.closeSilently(is);
        }
    }

    public static String getExtension(String path) {
        int extPos = path.lastIndexOf(".");
        if (extPos >= 0) {
            return path.substring(extPos + 1);
        }
        return null;
    }

    public static String removeExtension(String path) {
        int extPos = path.lastIndexOf(".");
        if (extPos >= 0) {
            return path.substring(0, extPos);
        }
        return path;
    }

    public static File getBuildDir(Class clazz) {
        return LdiResourceUtil.getBuildDir(LdiResourceUtil.getResourcePath(clazz));
    }

    public static File getBuildDir(String path) {
        File dir = null;
        URL url = LdiResourceUtil.getResource(path);
        if ("file".equals(url.getProtocol())) {
            int num = path.split("/").length;
            dir = new File(LdiResourceUtil.getFileName(url));
            int i = 0;
            while (i < num) {
                ++i;
                dir = dir.getParentFile();
            }
        } else {
            dir = new File(LdiJarFileUtil.toJarFilePath(url));
        }
        return dir;
    }

    public static String toExternalForm(URL url) {
        String s = url.toExternalForm();
        return LdiURLUtil.decode(s, "UTF8");
    }

    public static String getFileName(URL url) {
        String s = url.getFile();
        return LdiURLUtil.decode(s, "UTF8");
    }

    public static File getFile(URL url) {
        File file = new File(LdiResourceUtil.getFileName(url));
        if (file != null && file.exists()) {
            return file;
        }
        return null;
    }

    public static File getResourceAsFile(String path) {
        return LdiResourceUtil.getResourceAsFile(path, null);
    }

    public static File getResourceAsFile(String path, String extension) {
        return LdiResourceUtil.getFile(LdiResourceUtil.getResource(path, extension));
    }

    public static File getResourceAsFileNoException(Class clazz) {
        return LdiResourceUtil.getResourceAsFileNoException(LdiResourceUtil.getResourcePath(clazz));
    }

    public static File getResourceAsFileNoException(String path) {
        URL url = LdiResourceUtil.getResourceNoException(path);
        if (url == null) {
            return null;
        }
        return LdiResourceUtil.getFile(url);
    }

    public static String convertPath(String path, Class clazz) {
        if (LdiResourceUtil.isExist(path)) {
            return path;
        }
        String prefix = clazz.getName().replace('.', '/').replaceFirst("/[^/]+$", "");
        String extendedPath = prefix + "/" + path;
        if (LdiResourceUtil.getResourceNoException(extendedPath) != null) {
            return extendedPath;
        }
        return path;
    }
}

