/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.autoregister;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lastaflute.di.core.autoregister.AutoNaming;
import org.lastaflute.di.util.LdiClassUtil;
import org.lastaflute.di.util.LdiStringUtil;

public abstract class AbstractAutoNaming
implements AutoNaming {
    protected static final String IMPL = "Impl";
    protected static final String BEAN = "Bean";
    protected boolean decapitalize = true;
    protected Map customizedNames = new HashMap();
    protected Map replaceRules = new LinkedHashMap();

    public AbstractAutoNaming() {
        this.addIgnoreClassSuffix(IMPL);
        this.addIgnoreClassSuffix(BEAN);
    }

    public void setCustomizedName(String fqcn, String name) {
        this.customizedNames.put(fqcn, name);
    }

    public void addIgnoreClassSuffix(String classSuffix) {
        this.addReplaceRule(classSuffix + "$", "");
    }

    public void addReplaceRule(String regex, String replacement) {
        this.replaceRules.put(Pattern.compile(regex), replacement);
    }

    public void clearReplaceRule() {
        this.customizedNames.clear();
        this.replaceRules.clear();
    }

    public void setDecapitalize(boolean decapitalize) {
        this.decapitalize = decapitalize;
    }

    @Override
    public String defineName(String packageName, String shortClassName) {
        String customizedName = this.getCustomizedName(packageName, shortClassName);
        if (customizedName != null) {
            return customizedName;
        }
        return this.makeDefineName(packageName, shortClassName);
    }

    protected String getCustomizedName(String packageName, String shortClassName) {
        String fqn = LdiClassUtil.concatName(packageName, shortClassName);
        return (String)this.customizedNames.get(fqn);
    }

    protected abstract String makeDefineName(String var1, String var2);

    protected String applyRule(String name) {
        for (Map.Entry entry : this.replaceRules.entrySet()) {
            Pattern pattern = (Pattern)entry.getKey();
            String replacement = (String)entry.getValue();
            Matcher matcher = pattern.matcher(name);
            name = matcher.replaceAll(replacement);
        }
        name = this.normalize(name);
        if (this.decapitalize) {
            name = LdiStringUtil.decapitalize(name);
        }
        return name;
    }

    protected String normalize(String name) {
        String[] names = name.split("\\.");
        StringBuffer buf = new StringBuffer(name.length());
        for (int i = 0; i < names.length; ++i) {
            buf.append(LdiStringUtil.capitalize(names[i]));
        }
        return new String(buf);
    }
}

