/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.deployer;

import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.deployer.ComponentDeployer;
import org.lastaflute.di.core.deployer.OuterComponentDeployer;
import org.lastaflute.di.core.deployer.PrototypeComponentDeployer;
import org.lastaflute.di.core.deployer.SingletonComponentDeployer;

public class ComponentDeployerFactory {
    private static Provider provider = new DefaultProvider();

    public static Provider getProvider() {
        return provider;
    }

    public static void setProvider(Provider p) {
        provider = p;
    }

    public static ComponentDeployer createSingletonComponentDeployer(ComponentDef cd) {
        return ComponentDeployerFactory.getProvider().createSingletonComponentDeployer(cd);
    }

    public static ComponentDeployer createPrototypeComponentDeployer(ComponentDef cd) {
        return ComponentDeployerFactory.getProvider().createPrototypeComponentDeployer(cd);
    }

    public static ComponentDeployer createServletContextComponentDeployer(ComponentDef cd) {
        return ComponentDeployerFactory.getProvider().createApplicationComponentDeployer(cd);
    }

    public static ComponentDeployer createSessionComponentDeployer(ComponentDef cd) {
        return ComponentDeployerFactory.getProvider().createSessionComponentDeployer(cd);
    }

    public static ComponentDeployer createRequestComponentDeployer(ComponentDef cd) {
        return ComponentDeployerFactory.getProvider().createRequestComponentDeployer(cd);
    }

    public static ComponentDeployer createOuterComponentDeployer(ComponentDef cd) {
        return ComponentDeployerFactory.getProvider().createOuterComponentDeployer(cd);
    }

    public static class DefaultProvider
    implements Provider {
        @Override
        public ComponentDeployer createSingletonComponentDeployer(ComponentDef cd) {
            return new SingletonComponentDeployer(cd);
        }

        @Override
        public ComponentDeployer createPrototypeComponentDeployer(ComponentDef cd) {
            return new PrototypeComponentDeployer(cd);
        }

        @Override
        public ComponentDeployer createRequestComponentDeployer(ComponentDef cd) {
            throw new UnsupportedOperationException("createRequestComponentDeployer");
        }

        @Override
        public ComponentDeployer createSessionComponentDeployer(ComponentDef cd) {
            throw new UnsupportedOperationException("createSessionComponentDeployer");
        }

        @Override
        public ComponentDeployer createApplicationComponentDeployer(ComponentDef cd) {
            throw new UnsupportedOperationException("createApplicationComponentDeployer");
        }

        @Override
        public ComponentDeployer createOuterComponentDeployer(ComponentDef cd) {
            return new OuterComponentDeployer(cd);
        }
    }

    public static interface Provider {
        public ComponentDeployer createSingletonComponentDeployer(ComponentDef var1);

        public ComponentDeployer createPrototypeComponentDeployer(ComponentDef var1);

        public ComponentDeployer createApplicationComponentDeployer(ComponentDef var1);

        public ComponentDeployer createSessionComponentDeployer(ComponentDef var1);

        public ComponentDeployer createRequestComponentDeployer(ComponentDef var1);

        public ComponentDeployer createOuterComponentDeployer(ComponentDef var1);
    }
}

