/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.factory;

import java.lang.reflect.Method;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.aop.Pointcut;
import org.lastaflute.di.core.aop.frame.MethodInterceptor;
import org.lastaflute.di.core.aop.impl.PointcutImpl;
import org.lastaflute.di.core.expression.ScriptingExpression;
import org.lastaflute.di.core.meta.AspectDef;
import org.lastaflute.di.core.meta.impl.AspectDefImpl;
import org.lastaflute.di.util.LdiStringUtil;

public class AspectDefFactory {
    protected AspectDefFactory() {
    }

    public static AspectDef createAspectDef(MethodInterceptor interceptor, Pointcut pointcut) {
        AspectDefImpl aspectDef = new AspectDefImpl(pointcut);
        aspectDef.setValue(interceptor);
        return aspectDef;
    }

    public static AspectDef createAspectDef(String interceptorName, Pointcut pointcut) {
        AspectDefImpl aspectDef = new AspectDefImpl(pointcut);
        aspectDef.setExpression(new ScriptingExpression(interceptorName));
        return aspectDef;
    }

    public static AspectDef createAspectDef(ComponentDef cd, Pointcut pointcut) {
        AspectDefImpl aspectDef = new AspectDefImpl(pointcut);
        aspectDef.setChildComponentDef(cd);
        return aspectDef;
    }

    public static AspectDef createAspectDef(String interceptorName, String pointcutStr) {
        Pointcut pointcut = AspectDefFactory.createPointcut(pointcutStr);
        return AspectDefFactory.createAspectDef(interceptorName, pointcut);
    }

    public static AspectDef createAspectDef(MethodInterceptor interceptor, String pointcutStr) {
        Pointcut pointcut = AspectDefFactory.createPointcut(pointcutStr);
        return AspectDefFactory.createAspectDef(interceptor, pointcut);
    }

    public static AspectDef createAspectDef(ComponentDef cd, String pointcutStr) {
        Pointcut pointcut = AspectDefFactory.createPointcut(pointcutStr);
        return AspectDefFactory.createAspectDef(cd, pointcut);
    }

    public static AspectDef createAspectDef(String interceptorName, Method method) {
        Pointcut pointcut = AspectDefFactory.createPointcut(method);
        return AspectDefFactory.createAspectDef(interceptorName, pointcut);
    }

    public static AspectDef createAspectDef(MethodInterceptor interceptor, Method method) {
        Pointcut pointcut = AspectDefFactory.createPointcut(method);
        return AspectDefFactory.createAspectDef(interceptor, pointcut);
    }

    public static AspectDef createAspectDef(ComponentDef cd, Method method) {
        Pointcut pointcut = AspectDefFactory.createPointcut(method);
        return AspectDefFactory.createAspectDef(cd, pointcut);
    }

    public static Pointcut createPointcut(String pointcutStr) {
        if (!LdiStringUtil.isEmpty(pointcutStr)) {
            String[] methodNames = LdiStringUtil.split(pointcutStr, ", \n");
            return new PointcutImpl(methodNames);
        }
        return null;
    }

    public static Pointcut createPointcut(Class clazz) {
        return new PointcutImpl(clazz);
    }

    public static Pointcut createPointcut(Method method) {
        if (method != null) {
            return new PointcutImpl(method);
        }
        return null;
    }
}

