/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.meta.impl;

import java.util.ArrayList;
import java.util.List;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.exception.TooManyRegistrationComponentException;
import org.lastaflute.di.core.exception.TooManyRegistrationRuntimeException;
import org.lastaflute.di.core.meta.TooManyRegistrationComponentDef;
import org.lastaflute.di.core.meta.impl.SimpleComponentDef;
import org.lastaflute.di.helper.misc.LdiExceptionMessageBuilder;

public class TooManyRegistrationComponentDefImpl
extends SimpleComponentDef
implements TooManyRegistrationComponentDef {
    private final Object key;
    private List componentDefs = new ArrayList();

    public TooManyRegistrationComponentDefImpl(Object key) {
        this.key = key;
    }

    @Override
    public void addComponentDef(ComponentDef cd) {
        this.componentDefs.add(cd);
    }

    @Override
    public Object getComponent() throws TooManyRegistrationRuntimeException {
        this.throwTooManyRegistrationRuntimeException();
        return null;
    }

    protected void throwTooManyRegistrationRuntimeException() {
        LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
        br.addNotice("Too many registration components.");
        br.addItem("Component Key");
        br.addElement(this.key);
        br.addItem("Registered Components");
        for (ComponentDef def : this.getComponentDefs()) {
            String componentName = def.getComponentName();
            String typeName = def.getComponentClass().getName();
            String definedPath = def.getContainer().getPath();
            br.addElement("name=" + componentName + ", type=" + typeName + ", path=" + definedPath);
        }
        String msg = br.buildExceptionMessage();
        throw new TooManyRegistrationComponentException(msg);
    }

    public int getComponentDefSize() {
        return this.componentDefs.size();
    }

    public ComponentDef getComponentDef(int index) {
        return (ComponentDef)this.componentDefs.get(index);
    }

    @Override
    public ComponentDef[] getComponentDefs() {
        return this.componentDefs.toArray(new ComponentDef[this.getComponentDefSize()]);
    }

    @Override
    public Class[] getComponentClasses() {
        Class[] classes = new Class[this.getComponentDefSize()];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = this.getComponentDef(i).getComponentClass();
        }
        return classes;
    }
}

