/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.lastaflute.di.exception.IllegalAccessRuntimeException;
import org.lastaflute.di.exception.SIllegalArgumentException;
import org.lastaflute.di.util.LdiMethodUtil;
import org.lastaflute.di.util.tiger.LdiReflectionUtil;

public class LdiFieldUtil {
    protected static final String REFLECTION_UTIL_CLASS_NAME = LdiReflectionUtil.class.getName();
    protected static final Method GET_ELEMENT_TYPE_OF_COLLECTION_FROM_FIELD_TYPE_METHOD = LdiFieldUtil.getElementTypeFromFieldTypeMethod("Collection");
    protected static final Method GET_ELEMENT_TYPE_OF_LIST_FROM_FIELD_TYPE_METHOD = LdiFieldUtil.getElementTypeFromFieldTypeMethod("List");
    protected static final Method GET_ELEMENT_TYPE_OF_SET_FROM_FIELD_TYPE_METHOD = LdiFieldUtil.getElementTypeFromFieldTypeMethod("Set");

    protected LdiFieldUtil() {
    }

    public static Object get(Field field, Object target) throws IllegalAccessRuntimeException {
        LdiFieldUtil.assertArgumentNotNull("field", field);
        try {
            return field.get(target);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessRuntimeException(field.getDeclaringClass(), ex);
        }
    }

    public static int getInt(Field field) throws IllegalAccessRuntimeException {
        return LdiFieldUtil.getInt(field, null);
    }

    public static int getInt(Field field, Object target) throws IllegalAccessRuntimeException {
        try {
            return field.getInt(target);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessRuntimeException(field.getDeclaringClass(), ex);
        }
    }

    public static String getString(Field field) throws IllegalAccessRuntimeException {
        return LdiFieldUtil.getString(field, null);
    }

    public static String getString(Field field, Object target) throws IllegalAccessRuntimeException {
        try {
            return (String)field.get(target);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessRuntimeException(field.getDeclaringClass(), ex);
        }
    }

    public static void set(Field field, Object target, Object value) throws IllegalAccessRuntimeException {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessRuntimeException(field.getDeclaringClass(), e);
        }
        catch (IllegalArgumentException e) {
            Class<?> clazz = field.getDeclaringClass();
            Class<?> fieldClass = field.getType();
            Class<?> valueClass = value == null ? null : value.getClass();
            Class<?> targetClass = target == null ? null : target.getClass();
            throw new SIllegalArgumentException("ESSR0094", new Object[]{clazz.getName(), clazz.getClassLoader(), fieldClass.getName(), fieldClass.getClassLoader(), field.getName(), valueClass == null ? null : valueClass.getName(), valueClass == null ? null : valueClass.getClassLoader(), value, targetClass == null ? null : targetClass.getName(), targetClass == null ? null : targetClass.getClassLoader()}, e);
        }
    }

    public static boolean isInstanceField(Field field) {
        int mod = field.getModifiers();
        return !Modifier.isStatic(mod);
    }

    public static boolean isPublicField(Field field) {
        int mod = field.getModifiers();
        return Modifier.isPublic(mod);
    }

    public static Class getElementTypeOfCollectionFromFieldType(Field field) {
        if (GET_ELEMENT_TYPE_OF_COLLECTION_FROM_FIELD_TYPE_METHOD == null) {
            return null;
        }
        return (Class)LdiMethodUtil.invoke(GET_ELEMENT_TYPE_OF_COLLECTION_FROM_FIELD_TYPE_METHOD, null, new Object[]{field});
    }

    public static Class getElementTypeOfListFromFieldType(Field field) {
        if (GET_ELEMENT_TYPE_OF_LIST_FROM_FIELD_TYPE_METHOD == null) {
            return null;
        }
        return (Class)LdiMethodUtil.invoke(GET_ELEMENT_TYPE_OF_LIST_FROM_FIELD_TYPE_METHOD, null, new Object[]{field});
    }

    public static Class getElementTypeOfSetFromFieldType(Field field) {
        if (GET_ELEMENT_TYPE_OF_SET_FROM_FIELD_TYPE_METHOD == null) {
            return null;
        }
        return (Class)LdiMethodUtil.invoke(GET_ELEMENT_TYPE_OF_SET_FROM_FIELD_TYPE_METHOD, null, new Object[]{field});
    }

    protected static Method getElementTypeFromFieldTypeMethod(String type) {
        try {
            Class<?> reflectionUtilClass = Class.forName(REFLECTION_UTIL_CLASS_NAME);
            return reflectionUtilClass.getMethod("getElementTypeOf" + type + "FromFieldType", Field.class);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected static void assertArgumentNotNull(String variableName, Object value) {
        if (variableName == null) {
            throw new IllegalArgumentException("The variableName should not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("The argument '" + variableName + "' should not be null.");
        }
    }
}

