/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.aop.proxy;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Map;
import org.lastaflute.di.core.aop.Aspect;
import org.lastaflute.di.core.aop.InterType;
import org.lastaflute.di.core.aop.Pointcut;
import org.lastaflute.di.core.aop.frame.MethodInterceptor;
import org.lastaflute.di.core.aop.impl.PointcutImpl;
import org.lastaflute.di.core.aop.javassist.AspectWeaver;
import org.lastaflute.di.exception.EmptyRuntimeException;
import org.lastaflute.di.helper.log.SLogger;
import org.lastaflute.di.util.LdiClassUtil;
import org.lastaflute.di.util.LdiConstructorUtil;
import org.lastaflute.di.util.LdiMethodUtil;

public class AopProxy
implements Serializable {
    static final long serialVersionUID = 0L;
    private static SLogger logger = SLogger.getLogger(AopProxy.class);
    private final Class targetClass;
    private final Class enhancedClass;
    private final Pointcut defaultPointcut;
    private final AspectWeaver weaver;

    public AopProxy(Class targetClass, Aspect[] aspects) {
        this(targetClass, aspects, null, null);
    }

    public AopProxy(Class targetClass, Aspect[] aspects, InterType[] interTypes) {
        this(targetClass, aspects, interTypes, null);
    }

    public AopProxy(Class targetClass, Aspect[] aspects, Map parameters) {
        this(targetClass, aspects, null, parameters);
    }

    public AopProxy(Class targetClass, Aspect[] aspects, InterType[] interTypes, Map parameters) {
        if (!(aspects != null && aspects.length != 0 || interTypes != null && interTypes.length != 0)) {
            throw new EmptyRuntimeException("aspects and interTypes");
        }
        this.targetClass = targetClass;
        this.defaultPointcut = new PointcutImpl(targetClass);
        this.weaver = new AspectWeaver(targetClass, parameters);
        this.setupAspects(aspects);
        this.weaver.setInterTypes(interTypes);
        this.enhancedClass = this.weaver.generateClass();
    }

    private void setupAspects(Aspect[] aspects) {
        if (aspects == null || aspects.length == 0) {
            return;
        }
        for (int i = 0; i < aspects.length; ++i) {
            Aspect aspect = aspects[i];
            if (aspect.getPointcut() != null) continue;
            aspect.setPointcut(this.defaultPointcut);
        }
        Method[] methods = this.targetClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (LdiMethodUtil.isBridgeMethod(method) || LdiMethodUtil.isSyntheticMethod(method)) continue;
            ArrayList<MethodInterceptor> interceptorList = new ArrayList<MethodInterceptor>();
            for (int j = 0; j < aspects.length; ++j) {
                Aspect aspect = aspects[j];
                if (!aspect.getPointcut().isApplied(method)) continue;
                interceptorList.add(aspect.getMethodInterceptor());
            }
            if (interceptorList.size() == 0) continue;
            if (!this.isApplicableAspect(method)) {
                logger.log("WSSR0009", new Object[]{this.targetClass.getName(), method.getName()});
                continue;
            }
            this.weaver.setInterceptors(method, interceptorList.toArray(new MethodInterceptor[interceptorList.size()]));
        }
    }

    public Class getEnhancedClass() {
        return this.enhancedClass;
    }

    public Object create() {
        return LdiClassUtil.newInstance(this.enhancedClass);
    }

    public Object create(Class[] argTypes, Object[] args) {
        Constructor constructor = LdiClassUtil.getConstructor(this.enhancedClass, argTypes);
        return LdiConstructorUtil.newInstance(constructor, args);
    }

    private boolean isApplicableAspect(Method method) {
        int mod = method.getModifiers();
        return !Modifier.isFinal(mod) && !Modifier.isStatic(mod);
    }
}

