/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.assembler;

import java.lang.reflect.Constructor;
import java.util.Collections;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.assembler.AbstractAssembler;
import org.lastaflute.di.core.assembler.ConstructorAssembler;
import org.lastaflute.di.core.exception.ClassUnmatchRuntimeException;
import org.lastaflute.di.core.exception.ComponentNotFoundRuntimeException;
import org.lastaflute.di.core.exception.IllegalConstructorRuntimeException;
import org.lastaflute.di.core.expression.Expression;
import org.lastaflute.di.helper.beans.BeanDesc;
import org.lastaflute.di.helper.beans.factory.BeanDescFactory;
import org.lastaflute.di.util.LdiClassUtil;
import org.lastaflute.di.util.LdiConstructorUtil;

public abstract class AbstractConstructorAssembler
extends AbstractAssembler
implements ConstructorAssembler {
    public AbstractConstructorAssembler(ComponentDef componentDef) {
        super(componentDef);
    }

    @Override
    public Object assemble() {
        if (this.getComponentDef().getExpression() != null) {
            return this.assembleExpression();
        }
        if (this.getComponentDef().getArgDefSize() > 0) {
            return this.assembleManual();
        }
        return this.doAssemble();
    }

    protected Object assembleExpression() throws ClassUnmatchRuntimeException {
        ComponentDef cd = this.getComponentDef();
        LaContainer container = cd.getContainer();
        Expression expression = cd.getExpression();
        Object component = expression.evaluate(Collections.emptyMap(), container, Object.class);
        Class<?> componentClass = cd.getComponentClass();
        if (componentClass != null && !componentClass.isInstance(component)) {
            throw new ClassUnmatchRuntimeException(componentClass, component != null ? component.getClass() : null);
        }
        if (componentClass == null) {
            cd.setComponentClass(component.getClass());
            cd.getContainer().registerByClass(cd);
        }
        return component;
    }

    protected abstract Object doAssemble();

    protected Object assembleManual() {
        Object[] args = new Object[this.getComponentDef().getArgDefSize()];
        for (int i = 0; i < args.length; ++i) {
            try {
                args[i] = this.getComponentDef().getArgDef(i).getValue(Object.class);
                continue;
            }
            catch (ComponentNotFoundRuntimeException cause) {
                throw new IllegalConstructorRuntimeException(this.getComponentDef().getComponentClass(), (Throwable)cause);
            }
        }
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(this.getComponentDef().getConcreteClass());
        return beanDesc.newInstance(args);
    }

    protected Object assembleDefault() {
        Constructor constructor = LdiClassUtil.getConstructor(this.getComponentDef().getConcreteClass(), null);
        return LdiConstructorUtil.newInstance(constructor, null);
    }
}

