/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.redefiner.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.assembler.AutoConstructorAssembler;
import org.lastaflute.di.redefiner.LaContainerPreparer;
import org.lastaflute.di.redefiner.util.ClassBuilderUtils;

public class ClassAutoConstructorAssembler
extends AutoConstructorAssembler {
    public ClassAutoConstructorAssembler(ComponentDef componentDef) {
        super(componentDef);
    }

    @Override
    protected Object doAssemble() {
        Object component = null;
        LaContainerPreparer preparer = ClassBuilderUtils.getPreparer(this.getComponentDef());
        if (preparer != null) {
            component = this.newInstance(preparer, this.getComponentDef());
        }
        if (component == null) {
            component = super.doAssemble();
        }
        return component;
    }

    protected Object newInstance(LaContainerPreparer preparer, ComponentDef componentDef) {
        Class<?> preparerType = preparer.getClass();
        String componentName = componentDef.getComponentName();
        String methodprefixNew = "new";
        Method method = ClassBuilderUtils.findMethod(preparerType, componentName, "new");
        if (method != null) {
            try {
                if (method.getParameterTypes().length == 0) {
                    return method.invoke((Object)preparer, new Object[0]);
                }
                return method.invoke((Object)preparer, componentDef.getConcreteClass());
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Can't invoke method for instanciating component: " + method.getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Can't invoke method for instanciating component: " + method.getName(), e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Can't invoke method for instanciating component: " + method.getName(), e);
            }
        }
        return null;
    }
}

