/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.lastaflute.di.util.LdiDecimalFormatUtil;
import org.lastaflute.di.util.LdiStringUtil;

public class LdiShortConversionUtil {
    protected LdiShortConversionUtil() {
    }

    public static Short toShort(Object o) {
        return LdiShortConversionUtil.toShort(o, null);
    }

    public static Short toShort(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Short) {
            return (Short)o;
        }
        if (o instanceof Number) {
            return new Short(((Number)o).shortValue());
        }
        if (o instanceof String) {
            return LdiShortConversionUtil.toShort((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return new Short(new SimpleDateFormat(pattern).format(o));
            }
            return new Short((short)((Date)o).getTime());
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? new Short(1) : new Short(0);
        }
        return LdiShortConversionUtil.toShort(o.toString());
    }

    private static Short toShort(String s) {
        if (LdiStringUtil.isEmpty(s)) {
            return null;
        }
        return new Short(LdiDecimalFormatUtil.normalize(s));
    }

    public static short toPrimitiveShort(Object o) {
        return LdiShortConversionUtil.toPrimitiveShort(o, null);
    }

    public static short toPrimitiveShort(Object o, String pattern) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            return ((Number)o).shortValue();
        }
        if (o instanceof String) {
            return LdiShortConversionUtil.toPrimitiveShort((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return Short.parseShort(new SimpleDateFormat(pattern).format(o));
            }
            return (short)((Date)o).getTime();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? (short)1 : 0;
        }
        return LdiShortConversionUtil.toPrimitiveShort(o.toString());
    }

    private static short toPrimitiveShort(String s) {
        if (LdiStringUtil.isEmpty(s)) {
            return 0;
        }
        return Short.parseShort(LdiDecimalFormatUtil.normalize(s));
    }
}

