/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.assembler;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.assembler.AbstractBindingTypeDef;
import org.lastaflute.di.core.exception.AutoBindingFailureException;
import org.lastaflute.di.core.exception.IllegalAutoBindingPropertyRuntimeException;
import org.lastaflute.di.core.util.BindingUtil;
import org.lastaflute.di.helper.beans.PropertyDesc;
import org.lastaflute.di.helper.misc.LdiExceptionMessageBuilder;

public class BindingTypeMustDef
extends AbstractBindingTypeDef {
    protected BindingTypeMustDef(String name) {
        super(name);
    }

    @Override
    protected void doBindProperty(ComponentDef componentDef, PropertyDesc propertyDesc, Object component) {
        if (!this.bindAutoProperty(componentDef, propertyDesc, component)) {
            Class<?> componentClass = BindingUtil.getComponentClass(componentDef, component);
            String propertyName = propertyDesc.getPropertyName();
            throw new IllegalAutoBindingPropertyRuntimeException(componentClass, propertyName);
        }
    }

    @Override
    protected void doBindResourceField(ComponentDef componentDef, Field field, Object component) {
        if (!this.bindAutoResourceField(componentDef, field, component)) {
            this.throwAutoBindingFailureException(componentDef, field, component);
        }
    }

    protected void throwAutoBindingFailureException(ComponentDef componentDef, Field field, Object component) {
        LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
        br.addNotice("Failed to auto-inject to the resource field.");
        br.addItem("Component Def");
        br.addElement(componentDef);
        br.addItem("Declaring Bean");
        br.addElement(component);
        br.addItem("Resource Field");
        br.addElement(Modifier.toString(field.getModifiers()) + " " + field.getType().getName() + " " + field.getName());
        String msg = br.buildExceptionMessage();
        throw new AutoBindingFailureException(msg);
    }

    public String toString() {
        return "mustDef:{" + this.name + "}";
    }
}

