/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.assembler;

import java.util.HashMap;
import java.util.Map;
import org.lastaflute.di.core.assembler.AutoBindingAutoDef;
import org.lastaflute.di.core.assembler.AutoBindingConstructorDef;
import org.lastaflute.di.core.assembler.AutoBindingNoneDef;
import org.lastaflute.di.core.assembler.AutoBindingPropertyDef;
import org.lastaflute.di.core.assembler.AutoBindingSemiAutoDef;
import org.lastaflute.di.core.exception.IllegalAutoBindingDefRuntimeException;
import org.lastaflute.di.core.meta.AutoBindingDef;

public class AutoBindingDefFactory {
    public static final AutoBindingDef AUTO = new AutoBindingAutoDef("auto");
    public static final AutoBindingDef CONSTRUCTOR = new AutoBindingConstructorDef("constructor");
    public static final AutoBindingDef PROPERTY = new AutoBindingPropertyDef("property");
    public static final AutoBindingDef NONE = new AutoBindingNoneDef("none");
    public static final AutoBindingDef SEMIAUTO = new AutoBindingSemiAutoDef("semiauto");
    private static Map autoBindingDefs = new HashMap();

    protected AutoBindingDefFactory() {
    }

    public static void addAutoBindingDef(AutoBindingDef autoBindingDef) {
        autoBindingDefs.put(autoBindingDef.getName(), autoBindingDef);
    }

    public static boolean existAutoBindingDef(String name) {
        return autoBindingDefs.containsKey(name);
    }

    public static AutoBindingDef getAutoBindingDef(String name) {
        if (!autoBindingDefs.containsKey(name)) {
            throw new IllegalAutoBindingDefRuntimeException(name);
        }
        return (AutoBindingDef)autoBindingDefs.get(name);
    }

    static {
        AutoBindingDefFactory.addAutoBindingDef(AUTO);
        AutoBindingDefFactory.addAutoBindingDef(CONSTRUCTOR);
        AutoBindingDefFactory.addAutoBindingDef(PROPERTY);
        AutoBindingDefFactory.addAutoBindingDef(NONE);
        AutoBindingDefFactory.addAutoBindingDef(SEMIAUTO);
    }
}

