/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.customizer;

import java.util.ArrayList;
import java.util.List;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.aop.LaMethodInvocation;
import org.lastaflute.di.core.aop.Pointcut;
import org.lastaflute.di.core.aop.frame.MethodInterceptor;
import org.lastaflute.di.core.aop.frame.MethodInvocation;
import org.lastaflute.di.core.aop.impl.NestedMethodInvocation;
import org.lastaflute.di.core.aop.interceptors.AbstractInterceptor;
import org.lastaflute.di.core.customizer.AbstractCustomizer;
import org.lastaflute.di.core.factory.AspectDefFactory;
import org.lastaflute.di.core.meta.AspectDef;
import org.lastaflute.di.core.meta.impl.SimpleComponentDef;
import org.lastaflute.di.util.LdiStringUtil;

public class AspectCustomizer
extends AbstractCustomizer {
    public static final String interceptorName_BINDING = "bindingType=may";
    public static final String pointcut_BINDING = "bindingType=may";
    public static final String useLookupAdapter_BINDING = "bindingType=may";
    private final List interceptorNames = new ArrayList();
    private String pointcut;
    private boolean useLookupAdapter;

    public void setInterceptorName(String interceptorName) {
        this.interceptorNames.clear();
        this.interceptorNames.add(interceptorName);
    }

    public void addInterceptorName(String interceptorName) {
        this.interceptorNames.add(interceptorName);
    }

    public void setPointcut(String pointcut) {
        this.pointcut = pointcut;
    }

    public void setUseLookupAdapter(boolean useLookupAdapter) {
        this.useLookupAdapter = useLookupAdapter;
    }

    @Override
    protected void doCustomize(ComponentDef componentDef) {
        if (this.useLookupAdapter) {
            LookupAdaptorInterceptor adaptor = new LookupAdaptorInterceptor(this.interceptorNames.toArray(new String[this.interceptorNames.size()]));
            AspectDef aspectDef = AspectDefFactory.createAspectDef((ComponentDef)new SimpleComponentDef(adaptor), this.createPointcut());
            componentDef.addAspectDef(aspectDef);
        } else {
            for (int i = 0; i < this.interceptorNames.size(); ++i) {
                AspectDef aspectDef = AspectDefFactory.createAspectDef((String)this.interceptorNames.get(i), this.createPointcut());
                componentDef.addAspectDef(aspectDef);
            }
        }
    }

    protected Pointcut createPointcut() {
        if (!LdiStringUtil.isEmpty(this.pointcut)) {
            return AspectDefFactory.createPointcut(this.pointcut);
        }
        if (this.targetInterface != null) {
            return AspectDefFactory.createPointcut(this.targetInterface);
        }
        return null;
    }

    public static class LookupAdaptorInterceptor
    extends AbstractInterceptor {
        private static final long serialVersionUID = 1L;
        protected String[] interceptorNames;

        public LookupAdaptorInterceptor(String[] interceptorNames) {
            this.interceptorNames = interceptorNames;
        }

        @Override
        public Object invoke(MethodInvocation invocation) throws Throwable {
            LaContainer container = this.getComponentDef(invocation).getContainer().getRoot();
            MethodInterceptor[] interceptors = new MethodInterceptor[this.interceptorNames.length];
            for (int i = 0; i < interceptors.length; ++i) {
                interceptors[i] = (MethodInterceptor)container.getComponent(this.interceptorNames[i]);
            }
            NestedMethodInvocation nestInvocation = new NestedMethodInvocation((LaMethodInvocation)invocation, interceptors);
            return nestInvocation.proceed();
        }
    }
}

