/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.factory.dixml.taghandler;

import java.util.function.Supplier;
import org.lastaflute.di.core.expression.Expression;
import org.lastaflute.di.core.expression.ScriptingExpression;
import org.lastaflute.di.core.meta.impl.ComponentNameExpression;
import org.lastaflute.di.core.meta.impl.LiteralExpression;
import org.lastaflute.di.helper.xml.TagHandler;
import org.lastaflute.di.helper.xml.TagHandlerContext;

public class AbstractTagHandler
extends TagHandler {
    private static final long serialVersionUID = 1L;

    protected Expression createExpression(TagHandlerContext context, String body) {
        return this.doCreateExpression(body, null);
    }

    protected Expression createExpression(TagHandlerContext context, String body, Supplier<ScriptingExpression> scriptingSupplier) {
        return this.doCreateExpression(body, scriptingSupplier);
    }

    protected Expression doCreateExpression(String body, Supplier<ScriptingExpression> scriptingSupplier) {
        String expr = body.trim();
        if ("null".equals(expr)) {
            return new LiteralExpression(expr, null);
        }
        if ("true".equals(expr)) {
            return new LiteralExpression(expr, Boolean.TRUE);
        }
        if ("false".equals(expr)) {
            return new LiteralExpression(expr, Boolean.FALSE);
        }
        if (this.isComponentName(expr)) {
            return new ComponentNameExpression(expr);
        }
        return this.createScriptingExpression(expr, scriptingSupplier);
    }

    protected ScriptingExpression createScriptingExpression(String expr, Supplier<ScriptingExpression> scriptingSupplier) {
        if (scriptingSupplier != null) {
            return scriptingSupplier.get();
        }
        return this.newScriptingExpression(expr);
    }

    protected ScriptingExpression newScriptingExpression(String expr) {
        return new ScriptingExpression(expr);
    }

    protected boolean isComponentName(String expr) {
        if (!Character.isJavaIdentifierStart(expr.charAt(0))) {
            return false;
        }
        for (int i = 1; i < expr.length(); ++i) {
            if (Character.isJavaIdentifierPart(expr.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

