/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.meta.impl;

import java.lang.reflect.Method;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.expression.Expression;
import org.lastaflute.di.core.meta.ArgDef;
import org.lastaflute.di.core.meta.MethodDef;
import org.lastaflute.di.core.util.ArgDefSupport;

public abstract class MethodDefImpl
implements MethodDef {
    private Method method;
    private String methodName;
    private final ArgDefSupport argDefSupport = new ArgDefSupport();
    private LaContainer container;
    private Expression expression;

    public MethodDefImpl(Method method) {
        this.method = method;
    }

    public MethodDefImpl(String methodName) {
        this.methodName = methodName;
    }

    @Override
    public void addArgDef(ArgDef argDef) {
        this.argDefSupport.addArgDef(argDef);
    }

    @Override
    public int getArgDefSize() {
        return this.argDefSupport.getArgDefSize();
    }

    @Override
    public ArgDef getArgDef(int index) {
        return this.argDefSupport.getArgDef(index);
    }

    @Override
    public Object[] getArgs() {
        int argDefSize = this.getArgDefSize();
        Object[] args = new Object[argDefSize];
        Class<?>[] parameterTypes = this.extractParameterTypes(argDefSize);
        for (int i = 0; i < argDefSize; ++i) {
            Class<Object> conversionType = parameterTypes != null ? parameterTypes[i] : Object.class;
            args[i] = this.getArgDef(i).getValue(conversionType);
        }
        return args;
    }

    protected Class<?>[] extractParameterTypes(int argDefSize) {
        Class<?>[] parameterTypes;
        Class<?>[] classArray = parameterTypes = this.method != null ? this.method.getParameterTypes() : null;
        if (parameterTypes != null && parameterTypes.length != argDefSize) {
            parameterTypes = null;
        }
        return parameterTypes;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public LaContainer getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(LaContainer container) {
        this.container = container;
        this.argDefSupport.setContainer(container);
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public void setExpression(Expression expression) {
        this.expression = expression;
    }
}

