/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.aop.interceptors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.lastaflute.di.core.aop.frame.MethodInvocation;
import org.lastaflute.di.core.aop.interceptors.AbstractInterceptor;
import org.lastaflute.di.helper.beans.exception.MethodNotFoundRuntimeException;
import org.lastaflute.di.util.LdiMethodUtil;

public abstract class ThrowsInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;
    public static final String METHOD_NAME = "handleThrowable";
    private Map methodMap = new HashMap();

    public ThrowsInterceptor() {
        Method[] methods = this.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (LdiMethodUtil.isBridgeMethod(m) || LdiMethodUtil.isSyntheticMethod(m) || !this.isHandleThrowable(m)) continue;
            this.methodMap.put(m.getParameterTypes()[0], m);
        }
        if (this.methodMap.size() == 0) {
            throw new MethodNotFoundRuntimeException(this.getClass(), METHOD_NAME, new Class[]{Throwable.class, MethodInvocation.class});
        }
    }

    private boolean isHandleThrowable(Method method) {
        return METHOD_NAME.equals(method.getName()) && method.getParameterTypes().length == 2 && Throwable.class.isAssignableFrom(method.getParameterTypes()[0]) && MethodInvocation.class.isAssignableFrom(method.getParameterTypes()[1]);
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            return invocation.proceed();
        }
        catch (Throwable t) {
            Method method = this.getMethod(t);
            if (method != null) {
                try {
                    return method.invoke((Object)this, t, invocation);
                }
                catch (InvocationTargetException ite) {
                    throw ite.getTargetException();
                }
            }
            throw t;
        }
    }

    private Method getMethod(Throwable t) {
        Class<?> clazz = t.getClass();
        Method method = (Method)this.methodMap.get(clazz);
        while (method == null && !clazz.equals(Throwable.class)) {
            clazz = clazz.getSuperclass();
            method = (Method)this.methodMap.get(clazz);
        }
        return method;
    }
}

