/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.aop.javassist;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import org.lastaflute.di.core.aop.LaMethodInvocation;
import org.lastaflute.di.core.aop.frame.MethodInterceptor;
import org.lastaflute.di.core.aop.javassist.AbstractGenerator;
import org.lastaflute.di.util.LdiClassUtil;
import org.lastaflute.di.util.LdiMethodUtil;

public class MethodInvocationClassGenerator
extends AbstractGenerator {
    protected final String enhancedClassName;
    protected CtClass methodInvocationClass;

    public MethodInvocationClassGenerator(ClassPool classPool, String invocationClassName, String targetClassName) {
        super(classPool);
        this.enhancedClassName = targetClassName;
        this.methodInvocationClass = this.getAndRenameCtClass(MethodInvocationTemplate.class, invocationClassName);
    }

    public void createProceedMethod(Method targetMethod, String invokeSuperMethodName) {
        CtMethod method = this.getDeclaredMethod(this.methodInvocationClass, "proceed", null);
        this.setMethodBody(method, MethodInvocationClassGenerator.createProceedMethodSource(targetMethod, this.enhancedClassName, invokeSuperMethodName));
    }

    public Class toClass(ClassLoader classLoader) {
        Class clazz = this.toClass(classLoader, this.methodInvocationClass);
        this.methodInvocationClass.detach();
        this.methodInvocationClass = null;
        return clazz;
    }

    public static String createProceedMethodSource(Method targetMethod, String enhancedClassName, String invokeSuperMethodName) {
        StringBuffer buf = new StringBuffer(1000);
        buf.append("{");
        buf.append("if (interceptorsIndex < interceptors.length) {");
        buf.append("return interceptors[interceptorsIndex++].invoke(this);");
        buf.append("}");
        buf.append(MethodInvocationClassGenerator.createReturnStatement(targetMethod, enhancedClassName, invokeSuperMethodName));
        buf.append("}");
        return new String(buf);
    }

    public static String createReturnStatement(Method targetMethod, String enhancedClassName, String invokeSuperMethodName) {
        if (LdiMethodUtil.isAbstract(targetMethod)) {
            return MethodInvocationClassGenerator.createThrowStatement(targetMethod, enhancedClassName);
        }
        String invokeSuper = "((" + enhancedClassName + ") target)." + invokeSuperMethodName + "(" + MethodInvocationClassGenerator.createArgumentString(targetMethod.getParameterTypes()) + ")";
        Class<?> returnType = targetMethod.getReturnType();
        if (returnType.equals(Void.TYPE)) {
            return invokeSuper + ";" + "return null;";
        }
        return "return " + MethodInvocationClassGenerator.toObject(returnType, invokeSuper) + ";";
    }

    public static String createThrowStatement(Method targetMethod, String enhancedClassName) {
        return "throw new java.lang.NoSuchMethodError(\"" + enhancedClassName + "." + targetMethod.getName() + "(" + MethodInvocationClassGenerator.createArgumentTypeString(targetMethod.getParameterTypes()) + ")\");";
    }

    public static String createArgumentString(Class[] argTypes) {
        if (argTypes == null || argTypes.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(1000);
        for (int i = 0; i < argTypes.length; ++i) {
            buf.append(MethodInvocationClassGenerator.fromObject(argTypes[i], "arguments[" + i + "]")).append(", ");
        }
        buf.setLength(buf.length() - 2);
        return new String(buf);
    }

    public static String createArgumentTypeString(Class[] argTypes) {
        if (argTypes == null || argTypes.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(1000);
        for (int i = 0; i < argTypes.length; ++i) {
            buf.append(LdiClassUtil.getSimpleClassName(argTypes[i])).append(", ");
        }
        buf.setLength(buf.length() - 2);
        return new String(buf);
    }

    public static class MethodInvocationTemplate
    implements LaMethodInvocation {
        private static Class targetClass;
        private static Method method;
        static MethodInterceptor[] interceptors;
        private static Map parameters;
        private Object target;
        private Object[] arguments;
        int interceptorsIndex;

        public MethodInvocationTemplate(Object target, Object[] arguments) {
            this.target = target;
            this.arguments = arguments;
        }

        @Override
        public Class<?> getTargetClass() {
            return targetClass;
        }

        @Override
        public Method getMethod() {
            return method;
        }

        @Override
        public AccessibleObject getStaticPart() {
            return method;
        }

        @Override
        public Object getParameter(String name) {
            if (parameters == null) {
                return null;
            }
            return parameters.get(name);
        }

        @Override
        public Object getThis() {
            return this.target;
        }

        @Override
        public Object[] getArguments() {
            return this.arguments;
        }

        @Override
        public Object proceed() throws Throwable {
            return null;
        }
    }
}

