/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.assembler;

import java.lang.reflect.Field;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.exception.IllegalPropertyDefinitionException;
import org.lastaflute.di.core.meta.BindingTypeDef;
import org.lastaflute.di.core.meta.PropertyDef;
import org.lastaflute.di.core.util.BindingUtil;
import org.lastaflute.di.helper.beans.PropertyDesc;
import org.lastaflute.di.helper.beans.exception.IllegalPropertyRuntimeException;
import org.lastaflute.di.helper.misc.LdiExceptionMessageBuilder;
import org.lastaflute.di.util.LdiFieldUtil;

public abstract class AbstractBindingTypeDef
implements BindingTypeDef {
    protected final String name;

    protected AbstractBindingTypeDef(String name) {
        this.name = name;
    }

    @Override
    public void bind(ComponentDef componentDef, PropertyDef propertyDef, PropertyDesc propertyDesc, Object component) {
        if (propertyDef != null && propertyDef.isValueGettable()) {
            if (propertyDesc != null && propertyDesc.isWritable()) {
                this.bindManualProperty(componentDef, propertyDef, propertyDesc, component);
            }
        } else if (propertyDesc != null && propertyDesc.isWritable()) {
            this.doBindProperty(componentDef, propertyDesc, component);
        }
    }

    protected void bindManualProperty(ComponentDef componentDef, PropertyDef propertyDef, PropertyDesc propertyDesc, Object component) {
        Object value = this.getValue(componentDef, propertyDef, component, propertyDesc.getPropertyType());
        this.setPropertyValue(componentDef, propertyDesc, component, value);
    }

    protected boolean bindAutoProperty(ComponentDef componentDef, PropertyDesc propertyDesc, Object component) {
        Class<?> clazz;
        Object[] values;
        Object value;
        ComponentDef cd;
        LaContainer container = componentDef.getContainer();
        String propName = propertyDesc.getPropertyName();
        Class<ComponentDef> propType = propertyDesc.getPropertyType();
        if (container.hasComponentDef(propType) && this.isAutoBindable(propName, propType, cd = container.getComponentDef(propType))) {
            Object value2 = this.getComponent(componentDef, propType, component, propName);
            this.setPropertyValue(componentDef, propertyDesc, component, value2);
            return true;
        }
        if (container.hasComponentDef(propName) && propType.isInstance(value = this.getComponent(componentDef, propName, component, propName))) {
            this.setPropertyValue(componentDef, propertyDesc, component, value);
            return true;
        }
        if (this.isPropertyAutoBindable(propType)) {
            if (container.hasComponentDef(propType)) {
                value = this.getComponent(componentDef, propType, component, propName);
                this.setPropertyValue(componentDef, propertyDesc, component, value);
                return true;
            }
            if (propType.isAssignableFrom(ComponentDef.class)) {
                this.setPropertyValue(componentDef, propertyDesc, component, componentDef);
                return true;
            }
        }
        if (BindingUtil.isAutoBindableArray(propType) && (values = container.findAllComponents(clazz = propType.getComponentType())).length > 0) {
            this.setPropertyValue(componentDef, propertyDesc, component, values);
            return true;
        }
        return false;
    }

    protected boolean isPropertyAutoBindable(Class<?> clazz) {
        return BindingUtil.isPropertyAutoBindable(clazz);
    }

    protected void setPropertyValue(ComponentDef componentDef, PropertyDesc propertyDesc, Object component, Object value) throws IllegalPropertyRuntimeException {
        if (value == null) {
            return;
        }
        try {
            propertyDesc.setValue(component, value);
        }
        catch (NumberFormatException ex) {
            throw new IllegalPropertyRuntimeException(componentDef.getComponentClass(), propertyDesc.getPropertyName(), (Throwable)ex);
        }
    }

    protected abstract void doBindProperty(ComponentDef var1, PropertyDesc var2, Object var3);

    @Override
    public void bind(ComponentDef componentDef, PropertyDef propertyDef, Field field, Object component) {
        if (propertyDef != null && propertyDef.isValueGettable()) {
            if (field != null) {
                this.bindManualResourceField(componentDef, propertyDef, field, component);
            }
        } else if (propertyDef != null && field != null) {
            this.doBindResourceField(componentDef, field, component);
        }
    }

    protected void bindManualResourceField(ComponentDef componentDef, PropertyDef propertyDef, Field field, Object component) {
        Object value = this.getValue(componentDef, propertyDef, component, field.getType());
        this.setResourceFieldValue(componentDef, field, component, value);
    }

    protected boolean bindAutoResourceField(ComponentDef componentDef, Field field, Object component) {
        Class<?> clazz;
        Object[] values;
        Object value;
        ComponentDef cd;
        LaContainer container = componentDef.getContainer();
        String propName = field.getName();
        Class<ComponentDef> propType = field.getType();
        boolean hasComponentByType = container.hasComponentDef(propType);
        if (hasComponentByType && this.isAutoBindable(propName, propType, cd = container.getComponentDef(propType))) {
            Object value2 = this.getComponent(componentDef, propType, component, propName);
            this.setResourceFieldValue(componentDef, field, component, value2);
            return true;
        }
        if (container.hasComponentDef(propName) && propType.isInstance(value = this.getComponent(componentDef, propName, component, propName))) {
            this.setResourceFieldValue(componentDef, field, component, value);
            return true;
        }
        if (this.isFieldAutoBindable(propType)) {
            if (hasComponentByType) {
                value = this.getComponent(componentDef, propType, component, propName);
                this.setResourceFieldValue(componentDef, field, component, value);
                return true;
            }
            if (propType.isAssignableFrom(ComponentDef.class)) {
                this.setResourceFieldValue(componentDef, field, component, componentDef);
                return true;
            }
        }
        if (BindingUtil.isAutoBindableArray(propType) && (values = container.findAllComponents(clazz = propType.getComponentType())).length > 0) {
            this.setResourceFieldValue(componentDef, field, component, values);
            return true;
        }
        return false;
    }

    protected boolean isFieldAutoBindable(Class<?> clazz) {
        return BindingUtil.isFieldAutoBindable(clazz);
    }

    protected void setResourceFieldValue(ComponentDef componentDef, Field field, Object component, Object value) throws IllegalPropertyRuntimeException {
        if (value == null) {
            return;
        }
        try {
            LdiFieldUtil.set(field, component, value);
        }
        catch (NumberFormatException ex) {
            throw new IllegalPropertyRuntimeException(componentDef.getComponentClass(), field.getName(), (Throwable)ex);
        }
    }

    protected abstract void doBindResourceField(ComponentDef var1, Field var2, Object var3);

    protected boolean isAutoBindable(String propertyName, Class<?> propertyType, ComponentDef cd) {
        String componentName = cd.getComponentName();
        if (componentName == null) {
            return false;
        }
        if (componentName.equals(propertyName)) {
            return true;
        }
        return componentName.endsWith('_' + propertyName);
    }

    protected Object getValue(ComponentDef componentDef, PropertyDef propertyDef, Object component, Class<?> resultType) throws IllegalPropertyRuntimeException {
        try {
            return propertyDef.getValue(resultType);
        }
        catch (RuntimeException cause) {
            this.throwPropertyValueGetFailureException(componentDef, propertyDef, component, cause);
            return null;
        }
    }

    protected void throwPropertyValueGetFailureException(ComponentDef componentDef, PropertyDef propertyDef, Object component, RuntimeException cause) {
        LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
        br.addNotice("Failed to get the value for the property.");
        if (componentDef != null) {
            br.addItem("Component Def");
            String componentName = componentDef.getComponentName();
            String typeName = componentDef.getComponentClass().getName();
            String definedPath = componentDef.getContainer().getPath();
            br.addElement("name=" + componentName + ", type=" + typeName + ", path=" + definedPath);
        }
        br.addItem("Property Owner");
        br.addElement(component);
        br.addItem("Property Definition");
        br.addElement(propertyDef);
        String msg = br.buildExceptionMessage();
        throw new IllegalPropertyDefinitionException(msg, cause);
    }

    protected Object getComponent(ComponentDef componentDef, Object key, Object component, String propertyName) throws IllegalPropertyRuntimeException {
        try {
            return componentDef.getContainer().getComponent(key);
        }
        catch (RuntimeException cause) {
            this.throwPropertyComponentGetFailureException(componentDef, key, component, propertyName, cause);
            return null;
        }
    }

    protected void throwPropertyComponentGetFailureException(ComponentDef componentDef, Object key, Object component, String propertyName, RuntimeException cause) {
        LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
        br.addNotice("Failed to get the component for the property by the key.");
        br.addItem("Component Key");
        br.addElement(key);
        if (componentDef != null) {
            br.addItem("Component Def");
            String componentName = componentDef.getComponentName();
            String typeName = componentDef.getComponentClass().getName();
            String definedPath = componentDef.getContainer().getPath();
            br.addElement("name=" + componentName + ", type=" + typeName + ", path=" + definedPath);
        }
        br.addItem("Property Owner");
        br.addElement(component);
        br.addItem("Property Name");
        br.addElement(propertyName);
        String msg = br.buildExceptionMessage();
        throw new IllegalPropertyDefinitionException(msg, cause);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BindingTypeDef)) {
            return false;
        }
        BindingTypeDef other = (BindingTypeDef)o;
        return this.name == null ? other.getName() == null : this.name.equals(other.getName());
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    @Override
    public String getName() {
        return this.name;
    }
}

