/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.assembler;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.ExternalContext;
import org.lastaflute.di.core.assembler.AbstractAssembler;
import org.lastaflute.di.core.assembler.PropertyAssembler;
import org.lastaflute.di.exception.EmptyRuntimeException;
import org.lastaflute.di.helper.beans.BeanDesc;
import org.lastaflute.di.helper.beans.PropertyDesc;
import org.lastaflute.di.helper.beans.exception.IllegalPropertyRuntimeException;

public abstract class AbstractPropertyAssembler
extends AbstractAssembler
implements PropertyAssembler {
    public AbstractPropertyAssembler(ComponentDef componentDef) {
        super(componentDef);
    }

    protected void bindExternally(BeanDesc beanDesc, ComponentDef componentDef, Object component, Set<String> names) throws EmptyRuntimeException {
        ExternalContext extCtx = componentDef.getContainer().getRoot().getExternalContext();
        if (extCtx == null) {
            throw new EmptyRuntimeException("externalContext");
        }
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            Object value;
            String name;
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            if (!pd.isWritable() || names.contains(name = pd.getPropertyName()) || (value = this.getValue(name, pd.getPropertyType(), extCtx)) == null) continue;
            try {
                pd.setValue(component, value);
                names.add(name);
                continue;
            }
            catch (IllegalPropertyRuntimeException ignore) {
                // empty catch block
            }
        }
    }

    protected Object getValue(String name, Class<?> type, ExternalContext extCtx) {
        Object[] values;
        if (type.isArray()) {
            Object[] values2 = this.getValues(name, extCtx);
            if (values2 != null) {
                return values2;
            }
        } else if (List.class.isAssignableFrom(type) && (values = this.getValues(name, extCtx)) != null) {
            return Arrays.asList(values);
        }
        return this.getValue(name, extCtx);
    }

    protected Object getValue(String name, ExternalContext extCtx) {
        Object value = extCtx.getRequestParameterMap().get(name);
        if (value != null) {
            return value;
        }
        value = extCtx.getRequestHeaderMap().get(name);
        if (value != null) {
            return value;
        }
        return extCtx.getRequestMap().get(name);
    }

    protected Object[] getValues(String name, ExternalContext extCtx) {
        Object[] values = (Object[])extCtx.getRequestParameterValuesMap().get(name);
        if (values != null && values.length > 0) {
            return values;
        }
        values = (Object[])extCtx.getRequestHeaderValuesMap().get(name);
        if (values != null && values.length > 0) {
            return values;
        }
        return null;
    }
}

