/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.meta.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.runtime.Desc;
import javassist.util.proxy.ProxyFactory;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.ContainerConstants;
import org.lastaflute.di.core.ExternalContext;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.exception.ComponentNotFoundRuntimeException;
import org.lastaflute.di.core.exception.ContainerNotRegisteredRuntimeException;
import org.lastaflute.di.core.exception.CyclicReferenceRuntimeException;
import org.lastaflute.di.core.external.ExternalContextComponentDefRegister;
import org.lastaflute.di.core.meta.MetaDef;
import org.lastaflute.di.core.meta.TooManyRegistrationComponentDef;
import org.lastaflute.di.core.meta.impl.ComponentDefImpl;
import org.lastaflute.di.core.meta.impl.LaContainerBehavior;
import org.lastaflute.di.core.meta.impl.LaContainerComponentDef;
import org.lastaflute.di.core.meta.impl.SimpleComponentDef;
import org.lastaflute.di.core.meta.impl.TooManyRegistrationComponentDefImpl;
import org.lastaflute.di.core.util.ComponentUtil;
import org.lastaflute.di.core.util.MetaDefSupport;
import org.lastaflute.di.core.util.Traversal;
import org.lastaflute.di.exception.ContainerInitFailureException;
import org.lastaflute.di.helper.log.LaLogger;
import org.lastaflute.di.helper.misc.LdiExceptionMessageBuilder;
import org.lastaflute.di.util.CaseInsensitiveMap;
import org.lastaflute.di.util.LdiStringUtil;

public class LaContainerImpl
implements LaContainer,
ContainerConstants {
    private static final LaLogger logger = LaLogger.getLogger(LaContainerImpl.class);
    protected Map<Object, ComponentDefHolder> componentDefMap = new HashMap<Object, ComponentDefHolder>();
    protected List<ComponentDef> componentDefList = new ArrayList<ComponentDef>();
    protected String namespace;
    protected String path;
    protected boolean initializeOnCreate;
    protected List<LaContainer> children = new ArrayList<LaContainer>();
    protected Map<LaContainer, Integer> childPositions = new HashMap<LaContainer, Integer>();
    protected List<LaContainer> parents = new ArrayList<LaContainer>();
    protected CaseInsensitiveMap descendants = new CaseInsensitiveMap();
    protected LaContainer root;
    protected ExternalContext externalContext;
    protected ExternalContextComponentDefRegister externalContextComponentDefRegister;
    protected MetaDefSupport metaDefSupport = new MetaDefSupport(this);
    protected boolean inited = false;
    protected ClassLoader classLoader = null;

    public LaContainerImpl() {
        this.root = this;
        this.register0(new SimpleComponentDef((Object)this, "container"));
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    @Override
    public LaContainer getRoot() {
        return this.root;
    }

    @Override
    public void setRoot(LaContainer root) {
        this.root = root != null ? root : this;
    }

    @Override
    public <COMPONENT> COMPONENT getComponent(Object componentKey) {
        this.assertParameterIsNotNull(componentKey, "componentKey");
        ComponentDef cd = LaContainerBehavior.acquireFromGetComponent(this, componentKey);
        if (cd == null) {
            return null;
        }
        return (COMPONENT)cd.getComponent();
    }

    @Override
    public Object[] findComponents(Object componentKey) {
        this.assertParameterIsNotNull(componentKey, "componentKey");
        ComponentDef[] componentDefs = this.findComponentDefs(componentKey);
        return this.toComponentArray(componentKey, componentDefs);
    }

    @Override
    public Object[] findAllComponents(Object componentKey) throws CyclicReferenceRuntimeException {
        this.assertParameterIsNotNull(componentKey, "componentKey");
        ComponentDef[] componentDefs = this.findAllComponentDefs(componentKey);
        return this.toComponentArray(componentKey, componentDefs);
    }

    @Override
    public Object[] findLocalComponents(Object componentKey) throws CyclicReferenceRuntimeException {
        this.assertParameterIsNotNull(componentKey, "componentKey");
        ComponentDef[] componentDefs = this.findLocalComponentDefs(componentKey);
        return this.toComponentArray(componentKey, componentDefs);
    }

    protected Object[] toComponentArray(Object componentKey, ComponentDef[] componentDefs) {
        int length = componentDefs.length;
        Object[] components = componentKey instanceof Class ? (Object[])Array.newInstance((Class)componentKey, length) : new Object[length];
        for (int i = 0; i < length; ++i) {
            components[i] = componentDefs[i].getComponent();
        }
        return components;
    }

    @Override
    public void injectDependency(Object outerComponent) {
        this.injectDependency(outerComponent, outerComponent.getClass());
    }

    @Override
    public void injectDependency(Object outerComponent, Class<?> componentClass) {
        this.assertParameterIsNotNull(outerComponent, "outerComponent");
        this.assertParameterIsNotNull(componentClass, "componentClass");
        ComponentDef cd = LaContainerBehavior.acquireFromInjectDependency(this, componentClass);
        if (cd != null) {
            cd.injectDependency(outerComponent);
        }
    }

    @Override
    public void injectDependency(Object outerComponent, String componentName) {
        this.assertParameterIsNotNull(outerComponent, "outerComponent");
        this.assertParameterIsNotEmpty(componentName, "componentName");
        ComponentDef cd = LaContainerBehavior.acquireFromInjectDependency(this, componentName);
        if (cd != null) {
            cd.injectDependency(outerComponent);
        }
    }

    @Override
    public void register(Object component) {
        this.assertParameterIsNotNull(component, "component");
        this.register(new SimpleComponentDef(component));
    }

    @Override
    public void register(Object component, String componentName) {
        this.assertParameterIsNotNull(component, "component");
        this.assertParameterIsNotEmpty(componentName, "componentName");
        this.register(new SimpleComponentDef(component, componentName));
    }

    @Override
    public void register(Class<?> componentClass) {
        this.assertParameterIsNotNull(componentClass, "componentClass");
        this.register(new ComponentDefImpl(componentClass));
    }

    @Override
    public void register(Class<?> componentClass, String componentName) {
        this.assertParameterIsNotNull(componentClass, "componentClass");
        this.assertParameterIsNotEmpty(componentName, "componentName");
        this.register(new ComponentDefImpl(componentClass, componentName));
    }

    @Override
    public void register(ComponentDef componentDef) {
        this.assertParameterIsNotNull(componentDef, "componentDef");
        this.register0(componentDef);
        this.componentDefList.add(componentDef);
    }

    public void register0(ComponentDef componentDef) {
        if (componentDef.getContainer() == null) {
            componentDef.setContainer(this);
        }
        this.registerByClass(componentDef);
        this.registerByName(componentDef);
    }

    @Override
    public void registerByClass(ComponentDef componentDef) {
        Class<?> componentClass = componentDef.getComponentClass();
        if (componentClass != null) {
            Class<?>[] classes = ComponentUtil.getAssignableClasses(componentClass);
            for (int i = 0; i < classes.length; ++i) {
                this.registerMap(classes[i], componentDef);
            }
        }
    }

    protected void registerByName(ComponentDef componentDef) {
        String componentName = componentDef.getComponentName();
        if (componentName != null) {
            this.registerMap(componentName, componentDef);
        }
    }

    protected void registerMap(Object key, ComponentDef componentDef) {
        this.registerMap(key, componentDef, this);
    }

    @Override
    public void registerMap(Object key, ComponentDef componentDef, LaContainer container) {
        int position = this.getContainerPosition(container);
        ComponentDefHolder holder = this.componentDefMap.get(key);
        if (holder == null) {
            holder = new ComponentDefHolder(position, componentDef);
            this.componentDefMap.put(key, holder);
        } else {
            if (position > holder.getPosition()) {
                return;
            }
            if (position < holder.getPosition()) {
                holder.setPosition(position);
                holder.setComponentDef(componentDef);
            } else if (container != this) {
                holder.setComponentDef(componentDef);
            } else {
                holder.setComponentDef(LaContainerImpl.createTooManyRegistration(key, holder.getComponentDef(), componentDef));
            }
        }
        this.registerParent(key, holder.getComponentDef());
    }

    protected void registerParent(Object key, ComponentDef componentDef) {
        for (int i = 0; i < this.getParentSize(); ++i) {
            LaContainer parent = this.getParent(i);
            parent.registerMap(key, componentDef, this);
            if (!this.isNeedNS(key, componentDef)) continue;
            parent.registerMap(this.namespace + '.' + key, componentDef, this);
        }
    }

    @Override
    public int getComponentDefSize() {
        return this.componentDefList.size();
    }

    @Override
    public ComponentDef getComponentDef(int index) {
        return this.componentDefList.get(index);
    }

    @Override
    public ComponentDef getComponentDef(Object key) throws ComponentNotFoundRuntimeException {
        this.assertParameterIsNotNull(key, "key");
        return LaContainerBehavior.acquireFromGetComponentDef(this, key);
    }

    @Override
    public ComponentDef[] findComponentDefs(Object key) throws ComponentNotFoundRuntimeException {
        this.assertParameterIsNotNull(key, "key");
        ComponentDef cd = this.internalGetComponentDef(key);
        return this.toComponentDefArray(cd);
    }

    @Override
    public ComponentDef[] findAllComponentDefs(final Object componentKey) {
        this.assertParameterIsNotNull(componentKey, "componentKey");
        final ArrayList componentDefs = new ArrayList();
        Traversal.forEachContainer(this, new Traversal.S2ContainerHandler(){

            @Override
            public Object processContainer(LaContainer container) {
                componentDefs.addAll(Arrays.asList(container.findLocalComponentDefs(componentKey)));
                return null;
            }
        });
        return componentDefs.toArray(new ComponentDef[componentDefs.size()]);
    }

    @Override
    public ComponentDef[] findLocalComponentDefs(Object componentKey) {
        ComponentDefHolder holder = this.componentDefMap.get(componentKey);
        if (holder == null || holder.getPosition() > 0) {
            return new ComponentDef[0];
        }
        return this.toComponentDefArray(holder.getComponentDef());
    }

    protected ComponentDef[] toComponentDefArray(ComponentDef cd) {
        if (cd == null) {
            return new ComponentDef[0];
        }
        if (cd instanceof TooManyRegistrationComponentDefImpl) {
            return ((TooManyRegistrationComponentDefImpl)cd).getComponentDefs();
        }
        return new ComponentDef[]{cd};
    }

    protected ComponentDef internalGetComponentDef(Object key) {
        String name;
        int index;
        ComponentDefHolder holder = this.componentDefMap.get(key);
        if (holder != null) {
            return holder.getComponentDef();
        }
        if (key instanceof String && (index = (name = (String)key).indexOf(46)) > 0) {
            String ns = name.substring(0, index);
            name = name.substring(index + 1);
            if (ns.equals(this.namespace)) {
                return this.internalGetComponentDef(name);
            }
        }
        return null;
    }

    @Override
    public boolean hasComponentDef(Object componentKey) {
        this.assertParameterIsNotNull(componentKey, "componentKey");
        return LaContainerBehavior.acquireFromHasComponentDef(this, componentKey) != null;
    }

    @Override
    public boolean hasDescendant(String path) {
        this.assertParameterIsNotEmpty(path, "path");
        return this.descendants.containsKey(path);
    }

    @Override
    public LaContainer getDescendant(String path) {
        LaContainer descendant = (LaContainer)this.descendants.get(path);
        if (descendant != null) {
            return descendant;
        }
        throw new ContainerNotRegisteredRuntimeException(path);
    }

    @Override
    public void registerDescendant(LaContainer descendant) {
        this.assertParameterIsNotNull(descendant, "descendant");
        this.descendants.put(descendant.getPath(), descendant);
    }

    @Override
    public void include(LaContainer child) {
        this.assertParameterIsNotNull(child, "child");
        this.children.add(child);
        this.childPositions.put(child, new Integer(this.children.size()));
        child.setRoot(this.getRoot());
        child.addParent(this);
    }

    protected int getContainerPosition(LaContainer container) {
        if (container == this) {
            return 0;
        }
        return this.childPositions.get(container);
    }

    protected boolean isNeedNS(Object key, ComponentDef cd) {
        return key instanceof String && this.namespace != null;
    }

    @Override
    public LaContainer findChild(String namespace) {
        for (LaContainer child : this.children) {
            if (!namespace.equals(child.getNamespace())) continue;
            return child;
        }
        for (LaContainer child : this.children) {
            LaContainer nestedFound = child.findChild(namespace);
            if (nestedFound == null) continue;
            return nestedFound;
        }
        return null;
    }

    @Override
    public int getChildSize() {
        return this.children.size();
    }

    @Override
    public LaContainer getChild(int index) {
        return this.children.get(index);
    }

    @Override
    public int getParentSize() {
        return this.parents.size();
    }

    @Override
    public LaContainer getParent(int index) {
        return this.parents.get(index);
    }

    @Override
    public void addParent(LaContainer parent) {
        this.parents.add(parent);
        for (Map.Entry<Object, ComponentDefHolder> entry : this.componentDefMap.entrySet()) {
            Object key = entry.getKey();
            ComponentDefHolder holder = entry.getValue();
            ComponentDef cd = holder.getComponentDef();
            parent.registerMap(key, cd, this);
            if (!this.isNeedNS(key, cd)) continue;
            parent.registerMap(this.namespace + '.' + key, cd, this);
        }
    }

    @Override
    public void init() {
        try {
            this.doInit();
        }
        catch (Throwable e) {
            this.throwContainerInitFailureException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInit() {
        if (this.inited) {
            return;
        }
        ExternalContextComponentDefRegister register = this.getRoot().getExternalContextComponentDefRegister();
        if (register != null) {
            register.registerComponentDefs(this);
        }
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            int i;
            for (i = 0; i < this.getChildSize(); ++i) {
                this.getChild(i).init();
            }
            for (i = 0; i < this.getComponentDefSize(); ++i) {
                this.getComponentDef(i).init();
            }
            this.inited = true;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    protected void throwContainerInitFailureException(Throwable cause) {
        if (cause instanceof ContainerInitFailureException) {
            throw (ContainerInitFailureException)cause;
        }
        LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
        br.addNotice("Failed to initialize the container.");
        br.addItem("Path");
        br.addElement(this.getPath());
        br.addItem("Namespace");
        br.addElement(this.getNamespace());
        int parentSize = this.getParentSize();
        if (parentSize > 0) {
            br.addItem("Included by");
            for (int i = 0; i < parentSize; ++i) {
                LaContainer parent = this.getParent(i);
                if (parent == null) continue;
                br.addElement(parent.getPath());
            }
        }
        String msg = br.buildExceptionMessage();
        throw new ContainerInitFailureException(msg, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (!this.inited) {
            return;
        }
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            int i;
            for (i = this.getComponentDefSize() - 1; 0 <= i; --i) {
                try {
                    this.getComponentDef(i).destroy();
                    continue;
                }
                catch (Throwable t) {
                    logger.error("ESSR0017", t);
                }
            }
            for (i = this.getChildSize() - 1; 0 <= i; --i) {
                this.getChild(i).destroy();
            }
            this.componentDefMap = null;
            this.componentDefList = null;
            this.namespace = null;
            this.path = null;
            this.children = null;
            this.childPositions = null;
            this.parents = null;
            this.descendants = null;
            this.externalContext = null;
            this.externalContextComponentDefRegister = null;
            this.metaDefSupport = null;
            this.classLoader = null;
            this.root = this;
            this.inited = false;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    public static ComponentDef createTooManyRegistration(Object key, ComponentDef currentComponentDef, ComponentDef newComponentDef) {
        if (currentComponentDef instanceof TooManyRegistrationComponentDef) {
            ((TooManyRegistrationComponentDef)currentComponentDef).addComponentDef(newComponentDef);
            return currentComponentDef;
        }
        TooManyRegistrationComponentDefImpl tmrcf = new TooManyRegistrationComponentDefImpl(key);
        tmrcf.addComponentDef(currentComponentDef);
        tmrcf.addComponentDef(newComponentDef);
        return tmrcf;
    }

    protected void assertParameterIsNotNull(Object parameter, String name) {
        if (parameter == null) {
            throw new IllegalArgumentException(name);
        }
    }

    protected void assertParameterIsNotEmpty(String parameter, String name) {
        if (LdiStringUtil.isEmpty(parameter)) {
            throw new IllegalArgumentException(name);
        }
    }

    public String toString() {
        Integer defCount = this.componentDefMap != null ? Integer.valueOf(this.componentDefMap.size()) : null;
        return "container:{path=" + this.path + ", def_count=" + defCount + "}";
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        this.componentDefMap.remove(namespace);
        this.namespace = namespace;
        this.registerMap(namespace, new LaContainerComponentDef(this, namespace));
    }

    @Override
    public boolean isInitializeOnCreate() {
        return this.initializeOnCreate;
    }

    @Override
    public void setInitializeOnCreate(boolean initializeOnCreate) {
        this.initializeOnCreate = initializeOnCreate;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    @Override
    public void setExternalContext(ExternalContext externalContext) {
        this.externalContext = externalContext;
    }

    @Override
    public ExternalContextComponentDefRegister getExternalContextComponentDefRegister() {
        return this.externalContextComponentDefRegister;
    }

    @Override
    public void setExternalContextComponentDefRegister(ExternalContextComponentDefRegister register) {
        this.externalContextComponentDefRegister = register;
    }

    @Override
    public void addMetaDef(MetaDef metaDef) {
        this.metaDefSupport.addMetaDef(metaDef);
    }

    @Override
    public MetaDef getMetaDef(int index) {
        return this.metaDefSupport.getMetaDef(index);
    }

    @Override
    public MetaDef getMetaDef(String name) {
        return this.metaDefSupport.getMetaDef(name);
    }

    @Override
    public MetaDef[] getMetaDefs(String name) {
        return this.metaDefSupport.getMetaDefs(name);
    }

    @Override
    public int getMetaDefSize() {
        return this.metaDefSupport.getMetaDefSize();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    static {
        Desc.useContextClassLoader = true;
        ProxyFactory.classLoaderProvider = new ProxyFactory.ClassLoaderProvider(){

            public ClassLoader get(ProxyFactory proxyFactory) {
                return Thread.currentThread().getContextClassLoader();
            }
        };
    }

    static class ComponentDefHolder {
        private int position;
        private ComponentDef componentDef;

        public ComponentDefHolder(int position, ComponentDef componentDef) {
            this.position = position;
            this.componentDef = componentDef;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public ComponentDef getComponentDef() {
            return this.componentDef;
        }

        public void setComponentDef(ComponentDef componentDef) {
            this.componentDef = componentDef;
        }
    }
}

