/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.aop.interceptors;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.aop.frame.MethodInvocation;
import org.lastaflute.di.core.aop.interceptors.AbstractInterceptor;
import org.lastaflute.di.exception.EmptyRuntimeException;
import org.lastaflute.di.helper.beans.BeanDesc;
import org.lastaflute.di.helper.beans.exception.MethodNotFoundRuntimeException;
import org.lastaflute.di.helper.beans.factory.BeanDescFactory;
import org.lastaflute.di.util.LdiMethodUtil;

public class PrototypeDelegateInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = -6138917007687873314L;
    private LaContainer container;
    private String targetName;
    private BeanDesc beanDesc;
    private final Map<String, String> methodNameMap = new HashMap<String, String>();

    public PrototypeDelegateInterceptor(LaContainer container) {
        this.container = container;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public void addMethodNameMap(String methodName, String targetMethodName) {
        this.methodNameMap.put(methodName, targetMethodName);
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.targetName == null) {
            throw new EmptyRuntimeException("targetName");
        }
        Method method = invocation.getMethod();
        if (!LdiMethodUtil.isAbstract(method)) {
            return invocation.proceed();
        }
        String methodName = method.getName();
        if (this.methodNameMap.containsKey(methodName)) {
            methodName = this.methodNameMap.get(methodName);
        }
        Object target = this.container.getComponent(this.targetName);
        if (this.beanDesc == null) {
            this.beanDesc = BeanDescFactory.getBeanDesc(target.getClass());
        }
        if (!this.beanDesc.hasMethod(methodName)) {
            throw new MethodNotFoundRuntimeException(this.getTargetClass(invocation), methodName, invocation.getArguments());
        }
        return this.beanDesc.invoke(target, methodName, invocation.getArguments());
    }
}

