/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.helper.beans.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.StringMemberValue;
import org.lastaflute.di.core.util.ClassPoolUtil;
import org.lastaflute.di.exception.EmptyRuntimeException;
import org.lastaflute.di.helper.beans.BeanDesc;
import org.lastaflute.di.helper.beans.PropertyDesc;
import org.lastaflute.di.helper.beans.annotation.ParameterName;
import org.lastaflute.di.helper.beans.exception.ConstructorNotFoundRuntimeException;
import org.lastaflute.di.helper.beans.exception.FieldNotFoundRuntimeException;
import org.lastaflute.di.helper.beans.exception.IllegalDiiguRuntimeException;
import org.lastaflute.di.helper.beans.exception.MethodNotFoundRuntimeException;
import org.lastaflute.di.helper.beans.exception.PropertyNotFoundRuntimeException;
import org.lastaflute.di.helper.beans.factory.ParameterizedClassDescFactory;
import org.lastaflute.di.helper.beans.impl.PropertyDescImpl;
import org.lastaflute.di.helper.log.LaLogger;
import org.lastaflute.di.util.ArrayMap;
import org.lastaflute.di.util.CaseInsensitiveMap;
import org.lastaflute.di.util.LdiClassUtil;
import org.lastaflute.di.util.LdiConstructorUtil;
import org.lastaflute.di.util.LdiDoubleConversionUtil;
import org.lastaflute.di.util.LdiFieldUtil;
import org.lastaflute.di.util.LdiFloatConversionUtil;
import org.lastaflute.di.util.LdiIntegerConversionUtil;
import org.lastaflute.di.util.LdiLongConversionUtil;
import org.lastaflute.di.util.LdiMethodUtil;
import org.lastaflute.di.util.LdiShortConversionUtil;
import org.lastaflute.di.util.LdiStringUtil;

public class BeanDescImpl
implements BeanDesc {
    private static final LaLogger logger = LaLogger.getLogger(BeanDescImpl.class);
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final Class<?>[] EMPTY_PARAM_TYPES = new Class[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String PARAMETER_NAME_ANNOTATION = ParameterName.class.getName();
    private Class<?> beanClass;
    private Constructor<?>[] constructors;
    private Map<TypeVariable<?>, Type> typeVariables;
    private CaseInsensitiveMap propertyDescCache = new CaseInsensitiveMap();
    private Map<String, Method[]> methodsCache = new HashMap<String, Method[]>();
    private ArrayMap<String, Field> fieldCache = new ArrayMap();
    private ArrayMap<String, List<Field>> hiddenFieldCache;
    private transient Set<String> invalidPropertyNames = new HashSet<String>();
    private Map<Constructor<?>, String[]> constructorParameterNamesCache;
    private Map<Method, String[]> methodParameterNamesCache;

    public BeanDescImpl(Class<?> beanClass) throws EmptyRuntimeException {
        if (beanClass == null) {
            throw new EmptyRuntimeException("beanClass");
        }
        this.beanClass = beanClass;
        this.constructors = beanClass.getConstructors();
        this.typeVariables = ParameterizedClassDescFactory.getTypeVariables(beanClass);
        this.setupPropertyDescs();
        this.setupMethods();
        this.setupFields();
    }

    @Override
    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public boolean hasPropertyDesc(String propertyName) {
        return this.propertyDescCache.get(propertyName) != null;
    }

    @Override
    public PropertyDesc getPropertyDesc(String propertyName) throws PropertyNotFoundRuntimeException {
        PropertyDesc pd = (PropertyDesc)this.propertyDescCache.get(propertyName);
        if (pd == null) {
            throw new PropertyNotFoundRuntimeException(this.beanClass, propertyName);
        }
        return pd;
    }

    private PropertyDesc getPropertyDesc0(String propertyName) {
        return (PropertyDesc)this.propertyDescCache.get(propertyName);
    }

    @Override
    public PropertyDesc getPropertyDesc(int index) {
        return (PropertyDesc)this.propertyDescCache.get(index);
    }

    @Override
    public int getPropertyDescSize() {
        return this.propertyDescCache.size();
    }

    @Override
    public boolean hasField(String fieldName) {
        return this.fieldCache.get(fieldName) != null;
    }

    @Override
    public Object newInstance(Object[] args) throws ConstructorNotFoundRuntimeException {
        Constructor<?> constructor = this.getSuitableConstructor(args);
        return LdiConstructorUtil.newInstance(constructor, args);
    }

    @Override
    public Object invoke(Object target, String methodName, Object[] args) {
        Method method = this.getSuitableMethod(methodName, args);
        return LdiMethodUtil.invoke(method, target, args);
    }

    @Override
    public Constructor<?> getSuitableConstructor(Object[] args) throws ConstructorNotFoundRuntimeException {
        Constructor<?> constructor;
        if (args == null) {
            args = EMPTY_ARGS;
        }
        if ((constructor = this.findSuitableConstructor(args)) != null) {
            return constructor;
        }
        constructor = this.findSuitableConstructorAdjustNumber(args);
        if (constructor != null) {
            return constructor;
        }
        throw new ConstructorNotFoundRuntimeException(this.beanClass, args);
    }

    @Override
    public Constructor<?> getConstructor(Class<?>[] paramTypes) {
        for (int i = 0; i < this.constructors.length; ++i) {
            if (!Arrays.equals(paramTypes, this.constructors[i].getParameterTypes())) continue;
            return this.constructors[i];
        }
        throw new ConstructorNotFoundRuntimeException(this.beanClass, paramTypes);
    }

    @Override
    public Method getMethod(String methodName) {
        return this.getMethod(methodName, EMPTY_PARAM_TYPES);
    }

    @Override
    public Method getMethodNoException(String methodName) {
        return this.getMethodNoException(methodName, EMPTY_PARAM_TYPES);
    }

    @Override
    public Method getMethod(String methodName, Class<?>[] paramTypes) {
        Method method = this.getMethodNoException(methodName, paramTypes);
        if (method != null) {
            return method;
        }
        throw new MethodNotFoundRuntimeException(this.beanClass, methodName, paramTypes);
    }

    @Override
    public Method getMethodNoException(String methodName, Class<?>[] paramTypes) {
        Method[] methods = this.methodsCache.get(methodName);
        if (methods == null) {
            return null;
        }
        for (int i = 0; i < methods.length; ++i) {
            if (!Arrays.equals(paramTypes, methods[i].getParameterTypes())) continue;
            return methods[i];
        }
        return null;
    }

    @Override
    public Method[] getMethods(String methodName) throws MethodNotFoundRuntimeException {
        Method[] methods = this.methodsCache.get(methodName);
        if (methods == null) {
            throw new MethodNotFoundRuntimeException(this.beanClass, methodName, null);
        }
        return methods;
    }

    @Override
    public boolean hasMethod(String methodName) {
        return this.methodsCache.get(methodName) != null;
    }

    @Override
    public String[] getMethodNames() {
        return this.methodsCache.keySet().toArray(new String[this.methodsCache.size()]);
    }

    @Override
    public String[] getConstructorParameterNames(Class<?>[] parameterTypes) {
        return this.getConstructorParameterNames(this.getConstructor(parameterTypes));
    }

    @Override
    public String[] getConstructorParameterNames(Constructor<?> constructor) {
        if (this.constructorParameterNamesCache == null) {
            this.constructorParameterNamesCache = this.createConstructorParameterNamesCache();
        }
        if (!this.constructorParameterNamesCache.containsKey(constructor)) {
            throw new ConstructorNotFoundRuntimeException(this.beanClass, constructor.getParameterTypes());
        }
        return this.constructorParameterNamesCache.get(constructor);
    }

    @Override
    public String[] getMethodParameterNamesNoException(String methodName, Class<?>[] parameterTypes) {
        return this.getMethodParameterNamesNoException(this.getMethod(methodName, parameterTypes));
    }

    @Override
    public String[] getMethodParameterNames(String methodName, Class<?>[] parameterTypes) {
        return this.getMethodParameterNames(this.getMethod(methodName, parameterTypes));
    }

    @Override
    public String[] getMethodParameterNames(Method method) {
        String[] names = this.getMethodParameterNamesNoException(method);
        if (names == null || names.length != method.getParameterTypes().length) {
            throw new IllegalDiiguRuntimeException();
        }
        return names;
    }

    @Override
    public String[] getMethodParameterNamesNoException(Method method) {
        if (this.methodParameterNamesCache == null) {
            this.methodParameterNamesCache = this.createMethodParameterNamesCache();
        }
        if (!this.methodParameterNamesCache.containsKey(method)) {
            throw new MethodNotFoundRuntimeException(this.beanClass, method.getName(), method.getParameterTypes());
        }
        return this.methodParameterNamesCache.get(method);
    }

    private Map<Constructor<?>, String[]> createConstructorParameterNamesCache() {
        HashMap map = new HashMap();
        ClassPool pool = ClassPoolUtil.getClassPool(this.beanClass);
        for (int i = 0; i < this.constructors.length; ++i) {
            Constructor<?> constructor = this.constructors[i];
            if (constructor.getParameterTypes().length == 0) {
                map.put(constructor, EMPTY_STRING_ARRAY);
                continue;
            }
            CtClass clazz = ClassPoolUtil.toCtClass(pool, constructor.getDeclaringClass());
            CtClass[] parameterTypes = ClassPoolUtil.toCtClassArray(pool, constructor.getParameterTypes());
            try {
                String[] names = this.getParameterNames((CtBehavior)clazz.getDeclaredConstructor(parameterTypes));
                map.put(constructor, names);
                continue;
            }
            catch (NotFoundException e) {
                logger.log("WSSR0084", new Object[]{this.beanClass.getName(), constructor});
            }
        }
        return map;
    }

    private Map<Method, String[]> createMethodParameterNamesCache() {
        HashMap<Method, String[]> map = new HashMap<Method, String[]>();
        ClassPool pool = ClassPoolUtil.getClassPool(this.beanClass);
        for (Method[] methods : this.methodsCache.values()) {
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (method.getParameterTypes().length == 0) {
                    map.put(methods[i], EMPTY_STRING_ARRAY);
                    continue;
                }
                CtClass clazz = ClassPoolUtil.toCtClass(pool, method.getDeclaringClass());
                CtClass[] parameterTypes = ClassPoolUtil.toCtClassArray(pool, method.getParameterTypes());
                try {
                    String[] names = this.getParameterNames((CtBehavior)clazz.getDeclaredMethod(method.getName(), parameterTypes));
                    map.put(methods[i], names);
                    continue;
                }
                catch (NotFoundException e) {
                    logger.log("WSSR0085", new Object[]{this.beanClass.getName(), method});
                }
            }
        }
        return map;
    }

    private String[] getParameterNames(CtBehavior behavior) throws NotFoundException {
        MethodInfo methodInfo = behavior.getMethodInfo();
        ParameterAnnotationsAttribute attribute = (ParameterAnnotationsAttribute)methodInfo.getAttribute("RuntimeVisibleParameterAnnotations");
        if (attribute == null) {
            return null;
        }
        int numParameters = behavior.getParameterTypes().length;
        String[] parameterNames = new String[numParameters];
        Annotation[][] annotationsArray = attribute.getAnnotations();
        if (annotationsArray == null || annotationsArray.length != numParameters) {
            return null;
        }
        for (int i = 0; i < numParameters; ++i) {
            String parameterName = this.getParameterName(annotationsArray[i]);
            if (parameterName == null) {
                return null;
            }
            parameterNames[i] = parameterName;
        }
        return parameterNames;
    }

    private String getParameterName(Annotation[] annotations) {
        Annotation nameAnnotation = null;
        for (int i = 0; i < annotations.length; ++i) {
            Annotation annotation = annotations[i];
            if (!PARAMETER_NAME_ANNOTATION.equals(annotation.getTypeName())) continue;
            nameAnnotation = annotation;
            break;
        }
        if (nameAnnotation == null) {
            return null;
        }
        return ((StringMemberValue)nameAnnotation.getMemberValue("value")).getValue();
    }

    private Constructor<?> findSuitableConstructor(Object[] args) {
        block0: for (int i = 0; i < this.constructors.length; ++i) {
            Class<?>[] paramTypes = this.constructors[i].getParameterTypes();
            if (paramTypes.length != args.length) continue;
            for (int j = 0; j < args.length; ++j) {
                if (args[j] != null && !LdiClassUtil.isAssignableFrom(paramTypes[j], args[j].getClass())) continue block0;
            }
            return this.constructors[i];
        }
        return null;
    }

    private Constructor<?> findSuitableConstructorAdjustNumber(Object[] args) {
        block0: for (int i = 0; i < this.constructors.length; ++i) {
            Class<?>[] paramTypes = this.constructors[i].getParameterTypes();
            if (paramTypes.length != args.length) continue;
            for (int j = 0; j < args.length; ++j) {
                if (args[j] != null && !LdiClassUtil.isAssignableFrom(paramTypes[j], args[j].getClass()) && !BeanDescImpl.adjustNumber(paramTypes, args, j)) continue block0;
            }
            return this.constructors[i];
        }
        return null;
    }

    private static boolean adjustNumber(Class<?>[] paramTypes, Object[] args, int index) {
        if (paramTypes[index].isPrimitive()) {
            if (paramTypes[index] == Integer.TYPE) {
                args[index] = LdiIntegerConversionUtil.toInteger(args[index]);
                return true;
            }
            if (paramTypes[index] == Double.TYPE) {
                args[index] = LdiDoubleConversionUtil.toDouble(args[index]);
                return true;
            }
            if (paramTypes[index] == Long.TYPE) {
                args[index] = LdiLongConversionUtil.toLong(args[index]);
                return true;
            }
            if (paramTypes[index] == Short.TYPE) {
                args[index] = LdiShortConversionUtil.toShort(args[index]);
                return true;
            }
            if (paramTypes[index] == Float.TYPE) {
                args[index] = LdiFloatConversionUtil.toFloat(args[index]);
                return true;
            }
        } else {
            if (paramTypes[index] == Integer.class) {
                args[index] = LdiIntegerConversionUtil.toInteger(args[index]);
                return true;
            }
            if (paramTypes[index] == Double.class) {
                args[index] = LdiDoubleConversionUtil.toDouble(args[index]);
                return true;
            }
            if (paramTypes[index] == Long.class) {
                args[index] = LdiLongConversionUtil.toLong(args[index]);
                return true;
            }
            if (paramTypes[index] == Short.class) {
                args[index] = LdiShortConversionUtil.toShort(args[index]);
                return true;
            }
            if (paramTypes[index] == Float.class) {
                args[index] = LdiFloatConversionUtil.toFloat(args[index]);
                return true;
            }
        }
        return false;
    }

    private void setupPropertyDescs() {
        Method[] methods = this.beanClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String propertyName;
            Method method = methods[i];
            if (LdiMethodUtil.isBridgeMethod(method) || LdiMethodUtil.isSyntheticMethod(method)) continue;
            String methodName = method.getName();
            if (methodName.startsWith("get")) {
                if (method.getParameterTypes().length != 0 || methodName.equals("getClass") || method.getReturnType() == Void.TYPE) continue;
                propertyName = BeanDescImpl.decapitalizePropertyName(methodName.substring(3));
                this.setupReadMethod(method, propertyName);
                continue;
            }
            if (methodName.startsWith("is")) {
                if (method.getParameterTypes().length != 0 || !method.getReturnType().equals(Boolean.TYPE) && !method.getReturnType().equals(Boolean.class)) continue;
                propertyName = BeanDescImpl.decapitalizePropertyName(methodName.substring(2));
                this.setupReadMethod(method, propertyName);
                continue;
            }
            if (!methodName.startsWith("set") || method.getParameterTypes().length != 1 || methodName.equals("setClass") || method.getReturnType() != Void.TYPE) continue;
            propertyName = BeanDescImpl.decapitalizePropertyName(methodName.substring(3));
            this.setupWriteMethod(method, propertyName);
        }
        Iterator<String> i = this.invalidPropertyNames.iterator();
        while (i.hasNext()) {
            this.propertyDescCache.remove(i.next());
        }
        this.invalidPropertyNames.clear();
    }

    private static String decapitalizePropertyName(String name) {
        if (LdiStringUtil.isEmpty(name)) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private void addPropertyDesc(PropertyDesc propertyDesc) throws EmptyRuntimeException {
        if (propertyDesc == null) {
            throw new EmptyRuntimeException("propertyDesc");
        }
        this.propertyDescCache.put(propertyDesc.getPropertyName(), (Object)propertyDesc);
    }

    private void setupReadMethod(Method readMethod, String propertyName) {
        Class<?> propertyType = readMethod.getReturnType();
        PropertyDesc propDesc = this.getPropertyDesc0(propertyName);
        if (propDesc != null) {
            if (!propDesc.getPropertyType().equals(propertyType)) {
                this.invalidPropertyNames.add(propertyName);
            } else {
                propDesc.setReadMethod(readMethod);
            }
        } else {
            this.addPropertyDesc(new PropertyDescImpl(propertyName, propertyType, readMethod, null, null, this));
        }
    }

    private void setupWriteMethod(Method writeMethod, String propertyName) {
        Class<?> propertyType = writeMethod.getParameterTypes()[0];
        PropertyDesc propDesc = this.getPropertyDesc0(propertyName);
        if (propDesc != null) {
            if (!propDesc.getPropertyType().equals(propertyType)) {
                this.invalidPropertyNames.add(propertyName);
            } else {
                propDesc.setWriteMethod(writeMethod);
            }
        } else {
            this.addPropertyDesc(new PropertyDescImpl(propertyName, propertyType, null, writeMethod, null, this));
        }
    }

    private Method getSuitableMethod(String methodName, Object[] args) throws MethodNotFoundRuntimeException {
        Method[] methods;
        Method method;
        if (args == null) {
            args = EMPTY_ARGS;
        }
        if ((method = this.findSuitableMethod(methods = this.getMethods(methodName), args)) != null) {
            return method;
        }
        method = this.findSuitableMethodAdjustNumber(methods, args);
        if (method != null) {
            return method;
        }
        throw new MethodNotFoundRuntimeException(this.beanClass, methodName, args);
    }

    private Method findSuitableMethod(Method[] methods, Object[] args) {
        block0: for (int i = 0; i < methods.length; ++i) {
            Class<?>[] paramTypes = methods[i].getParameterTypes();
            if (paramTypes.length != args.length) continue;
            for (int j = 0; j < args.length; ++j) {
                if (args[j] != null && !LdiClassUtil.isAssignableFrom(paramTypes[j], args[j].getClass())) continue block0;
            }
            return methods[i];
        }
        return null;
    }

    private Method findSuitableMethodAdjustNumber(Method[] methods, Object[] args) {
        block0: for (int i = 0; i < methods.length; ++i) {
            Class<?>[] paramTypes = methods[i].getParameterTypes();
            if (paramTypes.length != args.length) continue;
            for (int j = 0; j < args.length; ++j) {
                if (args[j] != null && !LdiClassUtil.isAssignableFrom(paramTypes[j], args[j].getClass()) && !BeanDescImpl.adjustNumber(paramTypes, args, j)) continue block0;
            }
            return methods[i];
        }
        return null;
    }

    private void setupMethods() {
        int i;
        ArrayMap<String, ArrayList<Method>> methodListMap = new ArrayMap<String, ArrayList<Method>>();
        Method[] methods = this.beanClass.getMethods();
        for (i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (LdiMethodUtil.isBridgeMethod(method) || LdiMethodUtil.isSyntheticMethod(method)) continue;
            String methodName = method.getName();
            ArrayList<Method> list = (ArrayList<Method>)methodListMap.get(methodName);
            if (list == null) {
                list = new ArrayList<Method>();
                methodListMap.put(methodName, list);
            }
            list.add(method);
        }
        for (i = 0; i < methodListMap.size(); ++i) {
            List methodList = (List)methodListMap.get(i);
            this.methodsCache.put((String)methodListMap.getKey(i), methodList.toArray(new Method[methodList.size()]));
        }
    }

    private void setupFields() {
        this.setupFields(this.beanClass);
    }

    private void setupFields(Class<?> targetClass) {
        if (targetClass.isInterface()) {
            this.setupFieldsByInterface(targetClass);
        } else {
            this.setupFieldsByClass(targetClass);
        }
    }

    private void setupFieldsByInterface(Class<?> interfaceClass) {
        this.addFields(interfaceClass);
        Class<?>[] interfaces = interfaceClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.setupFieldsByInterface(interfaces[i]);
        }
    }

    private void setupFieldsByClass(Class<?> targetClass) {
        this.addFields(targetClass);
        Class<?>[] interfaces = targetClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.setupFieldsByInterface(interfaces[i]);
        }
        Class<?> superClass = targetClass.getSuperclass();
        if (superClass != Object.class && superClass != null) {
            this.setupFieldsByClass(superClass);
        }
    }

    private void addFields(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            List<Field> hiddenFieldList;
            Field field = fields[i];
            String fname = field.getName();
            if (!this.fieldCache.containsKey(fname)) {
                PropertyDesc pd;
                field.setAccessible(true);
                this.fieldCache.put(fname, field);
                if (!LdiFieldUtil.isInstanceField(field)) continue;
                if (this.hasPropertyDesc(fname)) {
                    pd = this.getPropertyDesc(field.getName());
                    pd.setField(field);
                    continue;
                }
                if (!LdiFieldUtil.isPublicField(field)) continue;
                pd = new PropertyDescImpl(field.getName(), field.getType(), null, null, field, this);
                this.propertyDescCache.put(fname, (Object)pd);
                continue;
            }
            field.setAccessible(true);
            if (this.hiddenFieldCache == null) {
                this.hiddenFieldCache = new ArrayMap();
            }
            if ((hiddenFieldList = this.hiddenFieldCache.get(fname)) == null) {
                hiddenFieldList = new ArrayList<Field>(2);
                this.hiddenFieldCache.put(fname, hiddenFieldList);
            }
            hiddenFieldList.add(field);
        }
    }

    @Override
    public Object getFieldValue(String fieldName, Object target) throws FieldNotFoundRuntimeException {
        return LdiFieldUtil.get(this.getField(fieldName), target);
    }

    @Override
    public Field getField(String fieldName) {
        Field field = this.fieldCache.get(fieldName);
        if (field == null) {
            throw new FieldNotFoundRuntimeException(this.beanClass, fieldName);
        }
        return field;
    }

    @Override
    public Field getField(int index) {
        return this.fieldCache.get(index);
    }

    @Override
    public int getFieldSize() {
        return this.fieldCache.size();
    }

    @Override
    public List<Field> getHiddenFieldList(String fieldName) {
        List<Field> fieldList;
        if (this.hiddenFieldCache != null && (fieldList = this.hiddenFieldCache.get(fieldName)) != null) {
            return Collections.unmodifiableList(fieldList);
        }
        return Collections.emptyList();
    }

    Map<TypeVariable<?>, Type> getTypeVariables() {
        return this.typeVariables;
    }
}

