/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.jta.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.lastaflute.jta.core.ExtendedTransaction;
import org.lastaflute.jta.core.SynchronizationRegister;
import org.lastaflute.jta.core.XAResourceWrapper;
import org.lastaflute.jta.core.xa.XidImpl;
import org.lastaflute.jta.exception.LjtIllegalStateException;
import org.lastaflute.jta.exception.LjtRollbackException;
import org.lastaflute.jta.exception.LjtSystemException;
import org.lastaflute.jta.helper.LjtLinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionImpl
implements ExtendedTransaction,
SynchronizationRegister {
    private static Logger logger = LoggerFactory.getLogger(TransactionImpl.class);
    private static final int VOTE_READONLY = 0;
    private static final int VOTE_COMMIT = 1;
    private static final int VOTE_ROLLBACK = 2;
    private Xid xid;
    private int status = 6;
    private List<XAResourceWrapper> xaResourceWrappers = new ArrayList<XAResourceWrapper>();
    private List<Synchronization> synchronizations = new ArrayList<Synchronization>();
    private List<Synchronization> interposedSynchronizations = new ArrayList<Synchronization>();
    private Map<Object, Object> resourceMap = new HashMap<Object, Object>();
    private boolean suspended = false;
    private int branchId = 0;

    @Override
    public void begin() throws NotSupportedException, SystemException {
        this.status = 0;
        this.init();
        if (logger.isDebugEnabled()) {
            logger.debug("Begin transaction: {}", (Object)this);
        }
    }

    @Override
    public void suspend() throws SystemException {
        this.assertNotSuspended();
        this.assertActiveOrMarkedRollback();
        for (int i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            XAResourceWrapper xarw = this.getXAResourceWrapper(i);
            try {
                xarw.end(0x2000000);
                continue;
            }
            catch (XAException e) {
                throw new LjtSystemException("Failed to suspend the transaction: xid=" + this.xid, e);
            }
        }
        this.suspended = true;
    }

    private void assertNotSuspended() throws IllegalStateException {
        if (this.suspended) {
            throw new LjtIllegalStateException("Already suspended the transaction: xid=" + this.xid);
        }
    }

    private void assertActive() throws IllegalStateException {
        switch (this.status) {
            case 0: {
                break;
            }
            default: {
                this.throwIllegalStateException();
            }
        }
    }

    private void throwIllegalStateException() throws IllegalStateException {
        switch (this.status) {
            case 7: {
                throw new LjtIllegalStateException("Already begun preparing the transaction: xid=" + this.xid);
            }
            case 2: {
                throw new LjtIllegalStateException("Already prepared the transaction: xid=" + this.xid);
            }
            case 8: {
                throw new LjtIllegalStateException("Already begun committing the transaction: xid=" + this.xid);
            }
            case 3: {
                throw new LjtIllegalStateException("Already committed the transaction: xid=" + this.xid);
            }
            case 1: {
                throw new LjtIllegalStateException("Already marked as rollback the transaction: xid=" + this.xid);
            }
            case 9: {
                throw new LjtIllegalStateException("Already begun rollback the transaction: xid=" + this.xid);
            }
            case 4: {
                throw new LjtIllegalStateException("Already rollbacked the transaction: xid=" + this.xid);
            }
            case 6: {
                throw new LjtIllegalStateException("Not begun transaction: xid=" + this.xid);
            }
            case 5: {
                throw new LjtIllegalStateException("Unknown status of transaction: " + this.xid);
            }
        }
        throw new LjtIllegalStateException("Unexpected transaction status: " + this.status + " xid=" + this.xid);
    }

    private int getXAResourceWrapperSize() {
        return this.xaResourceWrappers.size();
    }

    private XAResourceWrapper getXAResourceWrapper(int index) {
        return this.xaResourceWrappers.get(index);
    }

    @Override
    public void resume() throws SystemException {
        this.assertSuspended();
        this.assertActiveOrMarkedRollback();
        for (int i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            XAResourceWrapper xarw = this.getXAResourceWrapper(i);
            try {
                xarw.start(0x8000000);
                continue;
            }
            catch (XAException e) {
                throw new LjtSystemException("Failed to resume the transaction: xid=" + this.xid, e);
            }
        }
        this.suspended = false;
    }

    private void assertSuspended() throws IllegalStateException {
        if (!this.suspended) {
            throw new LjtIllegalStateException("Not suspended for resume(): xid=" + this.xid);
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        try {
            this.assertNotSuspended();
            this.assertActive();
            this.beforeCompletion();
            if (this.status == 0) {
                this.endResources(0x4000000);
                if (this.getXAResourceWrapperSize() == 0) {
                    this.status = 3;
                } else if (this.getXAResourceWrapperSize() == 1) {
                    this.commitOnePhase();
                } else {
                    switch (this.prepareResources()) {
                        case 0: {
                            this.status = 3;
                            break;
                        }
                        case 1: {
                            this.commitTwoPhase();
                            break;
                        }
                        case 2: {
                            this.rollbackForVoteOK();
                        }
                    }
                }
                if (this.status == 3 && logger.isDebugEnabled()) {
                    logger.debug("Commit transaction: {}", (Object)this);
                }
            }
            boolean rolledBack = this.status != 3;
            this.afterCompletion();
            if (rolledBack) {
                throw new LjtRollbackException("Cannot commit the transaction: xid=" + this.xid);
            }
        }
        finally {
            this.destroy();
        }
    }

    private void beforeCompletion() {
        int i;
        for (i = 0; i < this.getSynchronizationSize() && this.status == 0; ++i) {
            this.beforeCompletion(this.getSynchronization(i));
        }
        for (i = 0; i < this.getInterposedSynchronizationSize() && this.status == 0; ++i) {
            this.beforeCompletion(this.getInterposedSynchronization(i));
        }
    }

    private void beforeCompletion(Synchronization sync) {
        try {
            sync.beforeCompletion();
        }
        catch (Throwable t) {
            logger.debug("Failed to process the before completion: " + sync, t);
            this.status = 1;
            this.endResources(0x20000000);
            this.rollbackResources();
        }
    }

    private void endResources(int flag) {
        for (int i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            XAResourceWrapper xarw = this.getXAResourceWrapper(i);
            try {
                xarw.end(flag);
                continue;
            }
            catch (Throwable t) {
                logger.debug("Failed to end the XA resource: " + xarw + " " + flag, t);
                this.status = 1;
            }
        }
    }

    private void commitOnePhase() {
        this.status = 8;
        XAResourceWrapper xari = this.getXAResourceWrapper(0);
        try {
            xari.commit(true);
            this.status = 3;
        }
        catch (Throwable t) {
            logger.debug("Failed to commit the XA resource: " + xari, t);
            this.status = 5;
        }
    }

    private int prepareResources() {
        XAResourceWrapper xarw;
        int i;
        this.status = 7;
        int vote = 0;
        LjtLinkedList xarwList = new LjtLinkedList();
        for (i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            xarw = this.getXAResourceWrapper(i);
            if (!xarw.isCommitTarget()) continue;
            xarwList.addFirst(xarw);
        }
        for (i = 0; i < xarwList.size(); ++i) {
            xarw = (XAResourceWrapper)xarwList.get(i);
            try {
                if (i == xarwList.size() - 1) {
                    xarw.commit(true);
                    xarw.setVoteOk(false);
                    vote = 1;
                    continue;
                }
                if (xarw.prepare() == 0) {
                    vote = 1;
                    continue;
                }
                xarw.setVoteOk(false);
                continue;
            }
            catch (Throwable t) {
                logger.debug("Failed to vote the XA resource: " + xarw, t);
                xarw.setVoteOk(false);
                this.status = 1;
                return 2;
            }
        }
        if (this.status == 7) {
            this.status = 2;
        }
        return vote;
    }

    private void commitTwoPhase() {
        this.status = 8;
        for (int i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            XAResourceWrapper xarw = this.getXAResourceWrapper(i);
            if (!xarw.isCommitTarget() || !xarw.isVoteOk()) continue;
            try {
                xarw.commit(false);
                continue;
            }
            catch (Throwable t) {
                logger.debug("Failed to commit the XA resource: " + xarw, t);
                this.status = 5;
            }
        }
        if (this.status == 8) {
            this.status = 3;
        }
    }

    private void rollbackForVoteOK() {
        this.status = 9;
        for (int i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            XAResourceWrapper xarw = this.getXAResourceWrapper(i);
            if (!xarw.isVoteOk()) continue;
            try {
                xarw.rollback();
                continue;
            }
            catch (Throwable t) {
                logger.debug("Failed to rollback the XA resource: " + xarw, t);
                this.status = 5;
            }
        }
        if (this.status == 9) {
            this.status = 4;
        }
    }

    private void afterCompletion() {
        int i;
        int status = this.status;
        this.status = 6;
        for (i = 0; i < this.getInterposedSynchronizationSize(); ++i) {
            this.afterCompletion(status, this.getInterposedSynchronization(i));
        }
        for (i = 0; i < this.getSynchronizationSize(); ++i) {
            this.afterCompletion(status, this.getSynchronization(i));
        }
    }

    private void afterCompletion(int status, Synchronization sync) {
        try {
            sync.afterCompletion(status);
        }
        catch (Throwable t) {
            logger.debug("Failed to process the after completion: " + sync + " " + status, t);
        }
    }

    private int getSynchronizationSize() {
        return this.synchronizations.size();
    }

    private Synchronization getSynchronization(int index) {
        return this.synchronizations.get(index);
    }

    private int getInterposedSynchronizationSize() {
        return this.interposedSynchronizations.size();
    }

    private Synchronization getInterposedSynchronization(int index) {
        return this.interposedSynchronizations.get(index);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        try {
            this.assertNotSuspended();
            this.assertActiveOrMarkedRollback();
            this.endResources(0x20000000);
            this.rollbackResources();
            if (logger.isDebugEnabled()) {
                logger.debug("Rollback transaction: {}", (Object)this);
            }
            this.afterCompletion();
        }
        finally {
            this.destroy();
        }
    }

    private void assertActiveOrMarkedRollback() throws IllegalStateException {
        switch (this.status) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                this.throwIllegalStateException();
            }
        }
    }

    private void rollbackResources() {
        this.status = 9;
        for (int i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            XAResourceWrapper xarw = this.getXAResourceWrapper(i);
            try {
                if (!xarw.isCommitTarget()) continue;
                xarw.rollback();
                continue;
            }
            catch (Throwable t) {
                logger.debug("Failed to rollback the XA resource: " + xarw, t);
                this.status = 5;
            }
        }
        if (this.status == 9) {
            this.status = 4;
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.assertNotSuspended();
        this.assertActiveOrPreparingOrPrepared();
        this.status = 1;
    }

    private void assertActiveOrPreparingOrPrepared() throws IllegalStateException {
        switch (this.status) {
            case 0: 
            case 2: 
            case 7: {
                break;
            }
            default: {
                this.throwIllegalStateException();
            }
        }
    }

    public boolean enlistResource(XAResource xaResource) throws RollbackException, IllegalStateException, SystemException {
        boolean commitTarget;
        boolean oracled = xaResource.getClass().getName().startsWith("oracle");
        this.assertNotSuspended();
        this.assertActive();
        Xid xid = null;
        for (int i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            XAResourceWrapper xarw = this.getXAResourceWrapper(i);
            if (xaResource.equals(xarw.getXAResource())) {
                return false;
            }
            if (oracled) continue;
            try {
                if (!xaResource.isSameRM(xarw.getXAResource())) continue;
                xid = xarw.getXid();
                break;
            }
            catch (XAException ex) {
                throw new IllegalStateException(ex.toString());
            }
        }
        int flag = xid == null ? 0 : 0x200000;
        boolean bl = commitTarget = xid == null;
        if (xid == null) {
            xid = this.createXidBranch();
        }
        try {
            xaResource.start(xid, flag);
            this.xaResourceWrappers.add(new XAResourceWrapper(xaResource, xid, commitTarget));
            return true;
        }
        catch (XAException ex) {
            IllegalStateException ise = new IllegalStateException(ex.toString());
            ise.initCause(ex);
            throw ise;
        }
    }

    private Xid createXidBranch() {
        return new XidImpl(this.xid, ++this.branchId);
    }

    public boolean delistResource(XAResource xaResource, int flag) throws IllegalStateException, SystemException {
        this.assertNotSuspended();
        this.assertActiveOrMarkedRollback();
        for (int i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            XAResourceWrapper xarw = this.getXAResourceWrapper(i);
            if (!xaResource.equals(xarw.getXAResource())) continue;
            try {
                xarw.end(flag);
                return true;
            }
            catch (XAException ex) {
                logger.debug("Failed to end the XA resource: " + xarw + " " + flag, (Throwable)ex);
                this.status = 1;
                return false;
            }
        }
        throw new LjtIllegalStateException("Unregistered XA resource: " + xaResource);
    }

    public int getStatus() {
        return this.status;
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        this.assertNotSuspended();
        this.assertActive();
        this.synchronizations.add(sync);
    }

    @Override
    public void registerInterposedSynchronization(Synchronization sync) throws IllegalStateException {
        this.assertNotSuspended();
        this.assertActive();
        this.interposedSynchronizations.add(sync);
    }

    @Override
    public void putResource(Object key, Object value) throws IllegalStateException {
        this.assertNotSuspended();
        this.resourceMap.put(key, value);
    }

    @Override
    public Object getResource(Object key) throws IllegalStateException {
        this.assertNotSuspended();
        return this.resourceMap.get(key);
    }

    public Xid getXid() {
        return this.xid;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    private void init() {
        this.xid = new XidImpl();
    }

    private void destroy() {
        this.status = 6;
        this.xaResourceWrappers.clear();
        this.synchronizations.clear();
        this.interposedSynchronizations.clear();
        this.resourceMap.clear();
        this.suspended = false;
    }

    public String toString() {
        return this.xid.toString();
    }

    public List<Synchronization> getSynchronizations() {
        return this.synchronizations;
    }

    public List<Synchronization> getInterposedSynchronizations() {
        return this.interposedSynchronizations;
    }
}

