/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.lastaflute.di.util.LdiStringUtil;
import org.lastaflute.di.util.TigerBigDecimalConversion;

public class LdiBigDecimalConversionUtil {
    protected static final String TIGER_NORMALIZER_CLASS_NAME = TigerBigDecimalConversion.class.getName();
    protected static BigDecimalNormalizer normalizer = new DefaultNormalizer();

    protected LdiBigDecimalConversionUtil() {
    }

    public static BigDecimal toBigDecimal(Object o) {
        return LdiBigDecimalConversionUtil.toBigDecimal(o, null);
    }

    public static BigDecimal toBigDecimal(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return new BigDecimal(new SimpleDateFormat(pattern).format(o));
            }
            return new BigDecimal(Long.toString(((Date)o).getTime()));
        }
        if (o instanceof String) {
            String s = (String)o;
            if (LdiStringUtil.isEmpty(s)) {
                return null;
            }
            return normalizer.normalize(new BigDecimal(s));
        }
        return normalizer.normalize(new BigDecimal(o.toString()));
    }

    public static String toString(BigDecimal dec) {
        return normalizer.toString(dec);
    }

    static {
        try {
            Class<?> clazz = Class.forName(TIGER_NORMALIZER_CLASS_NAME);
            normalizer = (BigDecimalNormalizer)clazz.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class DefaultNormalizer
    implements BigDecimalNormalizer {
        @Override
        public BigDecimal normalize(BigDecimal dec) {
            return dec;
        }

        @Override
        public String toString(BigDecimal dec) {
            return dec.toString();
        }
    }

    public static interface BigDecimalNormalizer {
        public BigDecimal normalize(BigDecimal var1);

        public String toString(BigDecimal var1);
    }
}

