/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SStringBuilder
implements Serializable,
CharSequence {
    private static final long serialVersionUID = 1L;
    protected char[] value;
    protected int count;

    public SStringBuilder() {
        this(16);
    }

    public SStringBuilder(int capacity) {
        this.value = new char[capacity];
    }

    public SStringBuilder(String str) {
        this(str.length() + 16);
        this.append(str);
    }

    public SStringBuilder(CharSequence seq) {
        this(seq.length() + 16);
        this.append(seq);
    }

    public SStringBuilder append(boolean b) {
        if (b) {
            int newCount = this.count + 4;
            if (newCount > this.value.length) {
                this.expandCapacity(newCount);
            }
            this.value[this.count++] = 116;
            this.value[this.count++] = 114;
            this.value[this.count++] = 117;
            this.value[this.count++] = 101;
        } else {
            int newCount = this.count + 5;
            if (newCount > this.value.length) {
                this.expandCapacity(newCount);
            }
            this.value[this.count++] = 102;
            this.value[this.count++] = 97;
            this.value[this.count++] = 108;
            this.value[this.count++] = 115;
            this.value[this.count++] = 101;
        }
        return this;
    }

    public SStringBuilder append(char c) {
        int newCount = this.count + 1;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        this.value[this.count++] = c;
        return this;
    }

    public SStringBuilder append(char[] str) {
        int newCount = this.count + str.length;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(str, 0, this.value, this.count, str.length);
        this.count = newCount;
        return this;
    }

    public SStringBuilder append(char[] str, int offset, int len) {
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(str, offset, this.value, this.count, len);
        this.count = newCount;
        return this;
    }

    public SStringBuilder append(double d) {
        this.append(String.valueOf(d));
        return this;
    }

    public SStringBuilder append(float f) {
        this.append(String.valueOf(f));
        return this;
    }

    public SStringBuilder append(int i) {
        this.append(String.valueOf(i));
        return this;
    }

    public SStringBuilder append(CharSequence s) {
        if (s == null) {
            s = "null";
        }
        if (s instanceof String) {
            return this.append((String)s);
        }
        if (s instanceof StringBuffer) {
            return this.append((StringBuffer)s);
        }
        if (s instanceof SStringBuilder) {
            return this.append((SStringBuilder)s);
        }
        return this.append(s, 0, s.length());
    }

    public SStringBuilder append(CharSequence s, int start, int end) {
        if (s == null) {
            s = "null";
        }
        if (start < 0 || end < 0 || start > end || end > s.length()) {
            throw new IndexOutOfBoundsException("start " + start + ", end " + end + ", s.length() " + s.length());
        }
        int len = end - start;
        if (len == 0) {
            return this;
        }
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        for (int i = start; i < end; ++i) {
            this.value[this.count++] = s.charAt(i);
        }
        this.count = newCount;
        return this;
    }

    public SStringBuilder append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public SStringBuilder append(String str) {
        int len;
        if (str == null) {
            str = "null";
        }
        if ((len = str.length()) == 0) {
            return this;
        }
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        str.getChars(0, len, this.value, this.count);
        this.count = newCount;
        return this;
    }

    public SStringBuilder append(StringBuffer sb) {
        if (sb == null) {
            return this.append("null");
        }
        int len = sb.length();
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        sb.getChars(0, len, this.value, this.count);
        this.count = newCount;
        return this;
    }

    public SStringBuilder append(long l) {
        this.append(String.valueOf(l));
        return this;
    }

    public int capacity() {
        return this.value.length;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    public SStringBuilder delete(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            end = this.count;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = end - start;
        if (len > 0) {
            System.arraycopy(this.value, start + len, this.value, start, this.count - end);
            this.count -= len;
        }
        return this;
    }

    public SStringBuilder deleteCharAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        System.arraycopy(this.value, index + 1, this.value, index, this.count - index - 1);
        --this.count;
        return this;
    }

    public void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > this.value.length) {
            this.expandCapacity(minimumCapacity);
        }
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd < 0 || srcEnd > this.count) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
        }
        System.arraycopy(this.value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(String str, int fromIndex) {
        return SStringBuilder.indexOf(this.value, 0, this.count, str.toCharArray(), 0, str.length(), fromIndex);
    }

    public SStringBuilder insert(int offset, boolean b) {
        return this.insert(offset, String.valueOf(b));
    }

    public SStringBuilder insert(int offset, char c) {
        int newCount = this.count + 1;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, offset, this.value, offset + 1, this.count - offset);
        this.value[offset] = c;
        this.count = newCount;
        return this;
    }

    public SStringBuilder insert(int offset, char[] str) {
        if (offset < 0 || offset > this.length()) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        int len = str.length;
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        System.arraycopy(str, 0, this.value, offset, len);
        this.count = newCount;
        return this;
    }

    public SStringBuilder insert(int index, char[] str, int offset, int len) {
        if (index < 0 || index > this.length()) {
            throw new StringIndexOutOfBoundsException(index);
        }
        if (offset < 0 || len < 0 || offset > str.length - len) {
            throw new StringIndexOutOfBoundsException("offset " + offset + ", len " + len + ", str.length " + str.length);
        }
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, index, this.value, index + len, this.count - index);
        System.arraycopy(str, offset, this.value, index, len);
        this.count = newCount;
        return this;
    }

    public SStringBuilder insert(int offset, double d) {
        return this.insert(offset, String.valueOf(d));
    }

    public SStringBuilder insert(int offset, float f) {
        return this.insert(offset, String.valueOf(f));
    }

    public SStringBuilder insert(int offset, int i) {
        return this.insert(offset, String.valueOf(i));
    }

    public SStringBuilder insert(int dstOffset, CharSequence s) {
        if (s == null) {
            s = "null";
        }
        if (s instanceof String) {
            return this.insert(dstOffset, (String)s);
        }
        return this.insert(dstOffset, s, 0, s.length());
    }

    public SStringBuilder insert(int dstOffset, CharSequence s, int start, int end) {
        if (s == null) {
            s = "null";
        }
        if (dstOffset < 0 || dstOffset > this.length()) {
            throw new IndexOutOfBoundsException("dstOffset " + dstOffset);
        }
        if (start < 0 || end < 0 || start > end || end > s.length()) {
            throw new IndexOutOfBoundsException("start " + start + ", end " + end + ", s.length() " + s.length());
        }
        int len = end - start;
        if (len == 0) {
            return this;
        }
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, dstOffset, this.value, dstOffset + len, this.count - dstOffset);
        for (int i = start; i < end; ++i) {
            this.value[dstOffset++] = s.charAt(i);
        }
        this.count = newCount;
        return this;
    }

    public SStringBuilder insert(int offset, Object obj) {
        return this.insert(offset, String.valueOf(obj));
    }

    public SStringBuilder insert(int offset, String str) {
        int len;
        int newCount;
        if (offset < 0 || offset > this.length()) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (str == null) {
            str = "null";
        }
        if ((newCount = this.count + (len = str.length())) > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        str.getChars(0, len, this.value, offset);
        this.count = newCount;
        return this;
    }

    public SStringBuilder insert(int offset, long l) {
        return this.insert(offset, String.valueOf(l));
    }

    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.count);
    }

    public int lastIndexOf(String str, int fromIndex) {
        int start;
        char[] target = str.toCharArray();
        boolean targetOffset = false;
        int targetCount = str.length();
        int rightIndex = this.count - targetCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int strLastIndex = 0 + targetCount - 1;
        char strLastChar = target[strLastIndex];
        int min = targetCount - 1;
        int i = min + fromIndex;
        block0: while (true) {
            if (i >= min && this.value[i] != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetCount - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                if (this.value[j--] == target[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    @Override
    public int length() {
        return this.count;
    }

    public SStringBuilder replace(int start, int end, String str) {
        int len;
        int newCount;
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (start > this.count) {
            throw new StringIndexOutOfBoundsException("start > length()");
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException("start > end");
        }
        if (end > this.count) {
            end = this.count;
        }
        if (end > this.count) {
            end = this.count;
        }
        if ((newCount = this.count + (len = str.length()) - (end - start)) > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, end, this.value, start + len, this.count - end);
        str.getChars(0, str.length(), this.value, start);
        this.count = newCount;
        return this;
    }

    public SStringBuilder reverse() {
        int j = this.count - 1;
        for (int i = 0; i < j; ++i, --j) {
            char temp = this.value[i];
            this.value[i] = this.value[j];
            this.value[j] = temp;
        }
        return this;
    }

    public void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.value[index] = ch;
    }

    public void setLength(int newLength) {
        if (newLength < 0) {
            throw new StringIndexOutOfBoundsException(newLength);
        }
        if (newLength > this.value.length) {
            this.expandCapacity(newLength);
        }
        if (this.count < newLength) {
            while (this.count < newLength) {
                this.value[this.count] = '\u0000';
                ++this.count;
            }
        } else {
            this.count = newLength;
        }
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public String substring(int start) {
        return this.substring(start, this.count);
    }

    public String substring(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            throw new StringIndexOutOfBoundsException(end);
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException(end - start);
        }
        return new String(this.value, start, end - start);
    }

    @Override
    public String toString() {
        return new String(this.value, 0, this.count);
    }

    public void trimToSize() {
        if (this.count < this.value.length) {
            char[] newValue = new char[this.count];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
        }
    }

    void expandCapacity(int minimumCapacity) {
        int newCapacity = (this.value.length + 1) * 2;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        } else if (minimumCapacity > newCapacity) {
            newCapacity = minimumCapacity;
        }
        char[] newValue = new char[newCapacity];
        System.arraycopy(this.value, 0, newValue, 0, this.count);
        this.value = newValue;
    }

    final char[] getValue() {
        return this.value;
    }

    static int indexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    private SStringBuilder append(SStringBuilder sb) {
        if (sb == null) {
            return this.append("null");
        }
        int len = sb.length();
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        sb.getChars(0, len, this.value, this.count);
        this.count = newcount;
        return this;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.count);
        s.writeObject(this.value);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.count = s.readInt();
        this.value = (char[])s.readObject();
    }
}

