/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.factory;

import java.util.Set;
import org.lastaflute.di.Disposable;
import org.lastaflute.di.DisposableUtil;
import org.lastaflute.di.core.ExternalContext;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.assembler.AssemblerFactory;
import org.lastaflute.di.core.deployer.ComponentDeployerFactory;
import org.lastaflute.di.core.external.ExternalContextComponentDefRegister;
import org.lastaflute.di.core.factory.conbuilder.LaContainerBuilder;
import org.lastaflute.di.core.factory.conbuilder.impl.AbstractLaContainerBuilder;
import org.lastaflute.di.core.factory.dixml.DiXmlLaContainerBuilder;
import org.lastaflute.di.core.factory.pathresolver.PathResolver;
import org.lastaflute.di.core.factory.provider.LaContainerDefaultProvider;
import org.lastaflute.di.core.factory.provider.LaContainerProvider;
import org.lastaflute.di.core.factory.resresolver.ResourceResolver;
import org.lastaflute.di.core.meta.impl.LaContainerBehavior;
import org.lastaflute.di.exception.EmptyRuntimeException;
import org.lastaflute.di.util.LdiResourceUtil;
import org.lastaflute.di.util.LdiStringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaContainerFactory {
    private static final Logger parsingShowLogger = LoggerFactory.getLogger(LaContainerFactory.class);
    public static final String FACTORY_CONFIG_KEY = "org.lastaflute.di.core.factory.config";
    public static final String FACTORY_CONFIG_PATH = "lasta_di.xml";
    public static final String DEFAULT_BUILDER_NAME = "defaultBuilder";
    protected static boolean initialized;
    protected static boolean configuring;
    protected static LaContainer configurationContainer;
    protected static LaContainerProvider provider;
    protected static LaContainerBuilder defaultBuilder;
    protected static final ThreadLocal<Set<String>> processingPaths;

    public static synchronized LaContainer create(String path) {
        if (LdiStringUtil.isEmpty(path)) {
            throw new EmptyRuntimeException("path");
        }
        return LaContainerFactory.doCreate(path);
    }

    protected static LaContainer doCreate(String path) {
        if (!initialized) {
            LaContainerFactory.configure();
        }
        return LaContainerFactory.getProvider().create(path);
    }

    public static LaContainer include(LaContainer parent, String path) {
        if (!initialized) {
            LaContainerFactory.configure();
        }
        return LaContainerFactory.getProvider().include(parent, path);
    }

    public static void configure() {
        String configFile = System.getProperty(FACTORY_CONFIG_KEY, FACTORY_CONFIG_PATH);
        LaContainerFactory.configure(configFile);
    }

    public static synchronized void configure(String configFile) {
        if (configuring) {
            return;
        }
        configuring = true;
        LaContainerFactory.initializeDefaultProviderIfNeeds();
        LaContainerFactory.initializeDefaultBuilderIfNeeds();
        if (LdiResourceUtil.isExist(configFile)) {
            LaContainerFactory.doConfigure(configFile);
        }
        DisposableUtil.add(new Disposable(){

            @Override
            public void dispose() {
                LaContainerFactory.destroy();
            }
        });
        configuring = false;
        initialized = true;
    }

    protected static void initializeDefaultProviderIfNeeds() {
        if (provider == null) {
            provider = LaContainerFactory.newDefaultProvider();
        }
    }

    protected static LaContainerDefaultProvider newDefaultProvider() {
        return new LaContainerDefaultProvider();
    }

    protected static void initializeDefaultBuilderIfNeeds() {
        if (defaultBuilder == null) {
            defaultBuilder = LaContainerFactory.newDefaultContainerBuilder();
        }
    }

    protected static DiXmlLaContainerBuilder newDefaultContainerBuilder() {
        return new DiXmlLaContainerBuilder();
    }

    protected static void doConfigure(String configFile) {
        LaContainerFactory.show("...Reading {}", configFile);
        DiXmlLaContainerBuilder builder = LaContainerFactory.newConfigurationContainerBuilder();
        configurationContainer = builder.build(configFile);
        configurationContainer.init();
        Configurator configurator = configurationContainer.hasComponentDef(Configurator.class) ? (Configurator)configurationContainer.getComponent(Configurator.class) : LaContainerFactory.newDefaultConfigurator();
        configurator.configure(configurationContainer);
    }

    public static boolean isShowEnabled() {
        return parsingShowLogger.isInfoEnabled();
    }

    public static void show(String msg, Object ... objs) {
        parsingShowLogger.info(msg, objs);
    }

    protected static DiXmlLaContainerBuilder newConfigurationContainerBuilder() {
        return new DiXmlLaContainerBuilder();
    }

    protected static DefaultConfigurator newDefaultConfigurator() {
        return new DefaultConfigurator();
    }

    public static synchronized void destroy() {
        defaultBuilder = null;
        provider = null;
        if (configurationContainer != null) {
            configurationContainer.destroy();
        }
        configurationContainer = null;
        initialized = false;
    }

    public static synchronized LaContainer getConfigurationContainer() {
        return configurationContainer;
    }

    protected static LaContainerProvider getProvider() {
        return provider;
    }

    protected static void setProvider(LaContainerProvider vider) {
        provider = vider;
    }

    public static LaContainerBuilder getDefaultBuilder() {
        return defaultBuilder;
    }

    protected static void setDefaultBuilder(LaContainerBuilder builder) {
        defaultBuilder = builder;
    }

    static {
        configuring = false;
        processingPaths = new ThreadLocal();
        LaContainerFactory.configure();
    }

    public static class DefaultConfigurator
    implements Configurator {
        @Override
        public void configure(LaContainer configurationContainer) {
            provider = this.createProvider(configurationContainer);
            defaultBuilder = this.createDefaultBuilder(configurationContainer);
            this.setupBehavior(configurationContainer);
            this.setupDeployer(configurationContainer);
            this.setupAssembler(configurationContainer);
        }

        protected LaContainerProvider createProvider(LaContainer configurationContainer) {
            if (configurationContainer.hasComponentDef(LaContainerProvider.class)) {
                return (LaContainerProvider)configurationContainer.getComponent(LaContainerProvider.class);
            }
            if (provider instanceof LaContainerDefaultProvider) {
                LaContainerDefaultProvider dp = (LaContainerDefaultProvider)provider;
                if (configurationContainer.hasComponentDef(PathResolver.class)) {
                    dp.setPathResolver((PathResolver)configurationContainer.getComponent(PathResolver.class));
                }
                if (configurationContainer.hasComponentDef(ExternalContext.class)) {
                    dp.setExternalContext((ExternalContext)configurationContainer.getComponent(ExternalContext.class));
                }
                if (configurationContainer.hasComponentDef(ExternalContextComponentDefRegister.class)) {
                    dp.setExternalContextComponentDefRegister((ExternalContextComponentDefRegister)configurationContainer.getComponent(ExternalContextComponentDefRegister.class));
                }
            }
            return provider;
        }

        protected LaContainerBuilder createDefaultBuilder(LaContainer configurationContainer) {
            if (configurationContainer.hasComponentDef(LaContainerFactory.DEFAULT_BUILDER_NAME)) {
                return (LaContainerBuilder)configurationContainer.getComponent(LaContainerFactory.DEFAULT_BUILDER_NAME);
            }
            if (configurationContainer.hasComponentDef(ResourceResolver.class) && defaultBuilder instanceof AbstractLaContainerBuilder) {
                ResourceResolver resolver = (ResourceResolver)configurationContainer.getComponent(ResourceResolver.class);
                ((AbstractLaContainerBuilder)defaultBuilder).setResourceResolver(resolver);
            }
            return defaultBuilder;
        }

        protected void setupBehavior(LaContainer configurationContainer) {
            if (configurationContainer.hasComponentDef(LaContainerBehavior.Provider.class)) {
                LaContainerBehavior.setProvider((LaContainerBehavior.Provider)configurationContainer.getComponent(LaContainerBehavior.Provider.class));
            }
        }

        protected void setupDeployer(LaContainer configurationContainer) {
            if (configurationContainer.hasComponentDef(ComponentDeployerFactory.Provider.class)) {
                ComponentDeployerFactory.setProvider((ComponentDeployerFactory.Provider)configurationContainer.getComponent(ComponentDeployerFactory.Provider.class));
            }
        }

        protected void setupAssembler(LaContainer configurationContainer) {
            if (configurationContainer.hasComponentDef(AssemblerFactory.Provider.class)) {
                AssemblerFactory.setProvider((AssemblerFactory.Provider)configurationContainer.getComponent(AssemblerFactory.Provider.class));
            }
        }
    }

    public static interface Configurator {
        public void configure(LaContainer var1);
    }
}

