/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.factory.defbuilder.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.aop.annotation.Interceptor;
import org.lastaflute.di.core.aop.frame.MethodInterceptor;
import org.lastaflute.di.core.aop.impl.PointcutImpl;
import org.lastaflute.di.core.expression.Expression;
import org.lastaflute.di.core.factory.AspectDefFactory;
import org.lastaflute.di.core.factory.annohandler.AnnotationHandler;
import org.lastaflute.di.core.factory.defbuilder.impl.AbstractAspectDefBuilder;
import org.lastaflute.di.core.meta.impl.AspectDefImpl;
import org.lastaflute.di.helper.beans.BeanDesc;
import org.lastaflute.di.helper.beans.PropertyDesc;
import org.lastaflute.di.helper.beans.factory.BeanDescFactory;
import org.lastaflute.di.util.LdiMethodUtil;
import org.lastaflute.di.util.LdiStringUtil;

public class MetaAnnotationAspectDefBuilder
extends AbstractAspectDefBuilder {
    protected Class<? extends Annotation> metaAnnotationType;
    protected String interceptorNamespace;
    protected String interceptorSuffix;

    public MetaAnnotationAspectDefBuilder() {
    }

    public MetaAnnotationAspectDefBuilder(Class<? extends Annotation> metaAnnotationType, String interceptorSuffix) {
        this.metaAnnotationType = metaAnnotationType;
        this.interceptorNamespace = null;
        this.interceptorSuffix = interceptorSuffix;
    }

    public MetaAnnotationAspectDefBuilder(Class<? extends Annotation> metaAnnotationType, String interceptorNamespace, String interceptorSuffix) {
        this.metaAnnotationType = metaAnnotationType;
        this.interceptorNamespace = interceptorNamespace;
        this.interceptorSuffix = interceptorSuffix;
    }

    public Class<? extends Annotation> getMetaAnnotationType() {
        return this.metaAnnotationType;
    }

    public void setMetaAnnotationType(Class<? extends Annotation> metaAnnotationType) {
        this.metaAnnotationType = metaAnnotationType;
    }

    public String getInterceptorNamespace() {
        return this.interceptorNamespace;
    }

    public void setInterceptorNamespace(String interceptorNamespace) {
        this.interceptorNamespace = interceptorNamespace;
    }

    public String getInterceptorSuffix() {
        return this.interceptorSuffix;
    }

    public void setInterceptorSuffix(String interceptorSuffix) {
        this.interceptorSuffix = interceptorSuffix;
    }

    @Override
    public void appendAspectDef(AnnotationHandler annotationHandler, ComponentDef componentDef) {
        Class<?> componentClass = componentDef.getComponentClass();
        if (componentClass == null) {
            return;
        }
        this.processClass(componentDef, componentClass);
        this.processMethod(componentDef, componentClass);
    }

    protected void processClass(ComponentDef componentDef, Class<?> componentClass) {
        for (Annotation annotation : componentClass.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            Annotation metaAnnotation = annotationType.getAnnotation(this.getMetaAnnotationType());
            if (metaAnnotation == null) continue;
            String pointcut = this.getPointcut(annotation);
            AspectDefImpl aspectDef = new AspectDefImpl();
            if (!LdiStringUtil.isEmpty(pointcut)) {
                aspectDef.setPointcut(AspectDefFactory.createPointcut(pointcut));
            }
            aspectDef.setExpression(new MetaAnnotationExpression(annotation));
            componentDef.addAspectDef(aspectDef);
        }
    }

    protected void processMethod(ComponentDef componentDef, Class<?> componentClass) {
        for (Method method : componentClass.getMethods()) {
            int modifiers;
            if (method.isBridge() || method.isSynthetic() || !Modifier.isPublic(modifiers = method.getModifiers()) || Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
            for (Annotation annotation : method.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                Annotation metaAnnotation = annotationType.getAnnotation(this.getMetaAnnotationType());
                if (metaAnnotation == null) continue;
                AspectDefImpl aspectDef = new AspectDefImpl(new PointcutImpl(method));
                aspectDef.setExpression(new MetaAnnotationExpression(annotation));
                componentDef.addAspectDef(aspectDef);
            }
        }
    }

    protected String getPointcut(Annotation annotation) {
        for (Method method : annotation.getClass().getMethods()) {
            if (method.isBridge() || method.isSynthetic() || !"pointcut".equals(method.getName()) || method.getReturnType() != String.class) continue;
            return (String)String.class.cast(LdiMethodUtil.invoke(method, annotation, null));
        }
        return null;
    }

    protected String getInterceptorName(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        Interceptor interceptor = annotationType.getAnnotation(Interceptor.class);
        String value = interceptor.value();
        if (!LdiStringUtil.isEmpty(value)) {
            return value;
        }
        String namespace = this.getInterceptorNamespace();
        String interceptorName = LdiStringUtil.decapitalize(annotationType.getSimpleName());
        String suffix = this.getInterceptorSuffix();
        if (namespace != null) {
            return namespace + "." + interceptorName + suffix;
        }
        return interceptorName + suffix;
    }

    public class MetaAnnotationExpression
    implements Expression {
        protected final Annotation annotation;

        public MetaAnnotationExpression(Annotation annotation) {
            this.annotation = annotation;
        }

        @Override
        public Object evaluate(Map<String, ? extends Object> context, LaContainer container, Class<?> conversionType) {
            MethodInterceptor interceptor = (MethodInterceptor)MethodInterceptor.class.cast(container.getComponent(MetaAnnotationAspectDefBuilder.this.getInterceptorName(this.annotation)));
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(interceptor.getClass());
            for (Method method : this.annotation.annotationType().getMethods()) {
                PropertyDesc propertyDesc;
                String propertyName;
                if (method.isBridge() || method.isSynthetic() || "pointcut".equals(propertyName = method.getName()) || !beanDesc.hasPropertyDesc(propertyName) || !(propertyDesc = beanDesc.getPropertyDesc(propertyName)).isWritable()) continue;
                propertyDesc.setValue(interceptor, LdiMethodUtil.invoke(method, this.annotation, null));
            }
            return interceptor;
        }
    }
}

