/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.factory.provider;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.lastaflute.di.core.ExternalContext;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.exception.ExtensionNotFoundRuntimeException;
import org.lastaflute.di.core.external.ExternalContextComponentDefRegister;
import org.lastaflute.di.core.factory.LaContainerFactory;
import org.lastaflute.di.core.factory.conbuilder.LaContainerBuilder;
import org.lastaflute.di.core.factory.exception.CircularIncludeRuntimeException;
import org.lastaflute.di.core.factory.pathresolver.PathResolver;
import org.lastaflute.di.core.factory.pathresolver.impl.SimplePathResolver;
import org.lastaflute.di.core.factory.provider.LaContainerProvider;
import org.lastaflute.di.core.meta.impl.LaContainerImpl;
import org.lastaflute.di.util.LdiResourceUtil;
import org.lastaflute.di.util.LdiStringUtil;

public class LaContainerDefaultProvider
implements LaContainerProvider {
    public static final String pathResolver_BINDING = "bindingType=may";
    public static final String externalContext_BINDING = "bindingType=may";
    public static final String externalContextComponentDefRegister_BINDING = "bindingType=may";
    protected static final ThreadLocal<Set<String>> processingPaths = new ThreadLocal();
    protected PathResolver pathResolver = new SimplePathResolver();
    protected ExternalContext externalContext;
    protected ExternalContextComponentDefRegister externalContextComponentDefRegister;

    @Override
    public LaContainer create(String path) {
        LaContainer container;
        LaContainer configurationContainer = LaContainerFactory.getConfigurationContainer();
        ClassLoader classLoader = configurationContainer != null && configurationContainer.hasComponentDef(ClassLoader.class) ? (ClassLoader)configurationContainer.getComponent(ClassLoader.class) : Thread.currentThread().getContextClassLoader();
        LaContainer laContainer = container = LdiStringUtil.isEmpty(path) ? new LaContainerImpl() : this.build(path, classLoader);
        if (container.isInitializeOnCreate()) {
            container.init();
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LaContainer include(LaContainer parent, String path) {
        String realPath = this.pathResolver.resolvePath(parent.getPath(), path);
        LaContainerDefaultProvider.assertCircularInclude(parent, realPath);
        LaContainerDefaultProvider.enter(realPath);
        try {
            LaContainer child;
            LaContainer root;
            LaContainer laContainer = root = parent.getRoot();
            synchronized (laContainer) {
                if (root.hasDescendant(realPath)) {
                    this.showReadingLog(parent, path, realPath, true);
                    child = root.getDescendant(realPath);
                    parent.include(child);
                } else {
                    this.showReadingLog(parent, path, realPath, false);
                    String ext = this.getExtension(realPath);
                    LaContainerBuilder builder = this.getBuilder(ext);
                    child = builder.include(parent, realPath);
                    root.registerDescendant(child);
                    if (child.isInitializeOnCreate()) {
                        child.init();
                    }
                }
            }
            laContainer = child;
            return laContainer;
        }
        finally {
            LaContainerDefaultProvider.leave(realPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LaContainer build(String path, ClassLoader classLoader) {
        String realPath = this.pathResolver.resolvePath(null, path);
        this.showReadingLog(null, path, realPath, false);
        LaContainerDefaultProvider.enter(realPath);
        try {
            String ext = this.getExtension(realPath);
            LaContainer container = this.getBuilder(ext).build(realPath, classLoader);
            container.setExternalContext(this.externalContext);
            container.setExternalContextComponentDefRegister(this.externalContextComponentDefRegister);
            LaContainer laContainer = container;
            return laContainer;
        }
        finally {
            LaContainerDefaultProvider.leave(realPath);
        }
    }

    protected String getExtension(String path) {
        String ext = LdiResourceUtil.getExtension(path);
        if (ext == null) {
            throw new ExtensionNotFoundRuntimeException(path);
        }
        return ext;
    }

    protected LaContainerBuilder getBuilder(String ext) {
        String componentName = ext + "Redefined";
        LaContainer configurationContainer = LaContainerFactory.getConfigurationContainer();
        if (configurationContainer != null && configurationContainer.hasComponentDef(componentName)) {
            return (LaContainerBuilder)configurationContainer.getComponent(componentName);
        }
        return LaContainerFactory.getDefaultBuilder();
    }

    protected static void assertCircularInclude(LaContainer container, String path) {
        LaContainerDefaultProvider.assertCircularInclude(container, path, new LinkedList<String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void assertCircularInclude(LaContainer container, String path, LinkedList<String> paths) {
        paths.addFirst(container.getPath());
        try {
            if (path.equals(container.getPath())) {
                throw new CircularIncludeRuntimeException(path, new ArrayList<String>(paths));
            }
            for (int i = 0; i < container.getParentSize(); ++i) {
                LaContainerDefaultProvider.assertCircularInclude(container.getParent(i), path, paths);
            }
        }
        finally {
            paths.removeFirst();
        }
    }

    protected static void enter(String path) {
        Set<String> paths = LaContainerDefaultProvider.getProcessingPaths();
        if (paths.contains(path)) {
            throw new CircularIncludeRuntimeException(path, paths);
        }
        paths.add(path);
    }

    protected static void leave(String path) {
        Set<String> paths = LaContainerDefaultProvider.getProcessingPaths();
        paths.remove(path);
    }

    protected static Set<String> getProcessingPaths() {
        Set<String> paths = processingPaths.get();
        if (paths == null) {
            paths = new LinkedHashSet<String>();
            processingPaths.set(paths);
        }
        return paths;
    }

    protected void showReadingLog(LaContainer parent, String path, String realPath, boolean descendant) {
        if (LaContainerFactory.isShowEnabled()) {
            String indent = this.prepareReadingLogHierarchalIndent(parent);
            String pathExp = path + (descendant ? " (recycle)" : "");
            if (path.equals(realPath)) {
                LaContainerFactory.show("...Reading {}{}", indent, pathExp);
            } else {
                LaContainerFactory.show("...Reading {}{} realPath={}", indent, pathExp, realPath);
            }
        }
    }

    protected String prepareReadingLogHierarchalIndent(LaContainer parent) {
        StringBuilder indentSb = new StringBuilder();
        int indentSize = LaContainerDefaultProvider.getProcessingPaths().size();
        if (parent != null && this.isOriginatedInConfigurationContainer(parent)) {
            --indentSize;
        }
        for (int i = 0; i < indentSize; ++i) {
            indentSb.append("  ");
        }
        return indentSb.toString();
    }

    protected boolean isOriginatedInConfigurationContainer(LaContainer container) {
        LaContainer root = container.getRoot();
        LaContainer configurationContainer = LaContainerFactory.getConfigurationContainer();
        return root != null && configurationContainer != null && root != configurationContainer;
    }

    public PathResolver getPathResolver() {
        return this.pathResolver;
    }

    public void setPathResolver(PathResolver pathResolver) {
        this.pathResolver = pathResolver;
    }

    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    public void setExternalContext(ExternalContext externalContext) {
        this.externalContext = externalContext;
    }

    public ExternalContextComponentDefRegister getExternalContextComponentDefRegister() {
        return this.externalContextComponentDefRegister;
    }

    public void setExternalContextComponentDefRegister(ExternalContextComponentDefRegister externalContextComponentDefRegister) {
        this.externalContextComponentDefRegister = externalContextComponentDefRegister;
    }
}

