/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.redefiner.core;

import java.util.ArrayList;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.factory.LaContainerFactory;
import org.lastaflute.di.core.factory.annohandler.AnnotationHandler;
import org.lastaflute.di.core.factory.annohandler.AnnotationHandlerFactory;
import org.lastaflute.di.core.factory.dixml.exception.TagAttributeNotDefinedRuntimeException;
import org.lastaflute.di.core.factory.dixml.taghandler.ComponentTagHandler;
import org.lastaflute.di.core.meta.ArgDef;
import org.lastaflute.di.core.meta.impl.InstanceDefFactory;
import org.lastaflute.di.helper.xml.TagHandlerContext;
import org.lastaflute.di.redefiner.core.RedefinableXmlLaContainerBuilder;
import org.lastaflute.di.redefiner.util.LaContainerBuilderUtils;
import org.lastaflute.di.util.LdiStringUtil;

public class RedefinableComponentTagHandler
extends ComponentTagHandler {
    private static final long serialVersionUID = 2513809305883784501L;

    @Override
    public void end(TagHandlerContext context, String body) {
        ComponentDef componentDef = (ComponentDef)context.pop();
        AnnotationHandler annoHandler = AnnotationHandlerFactory.getAnnotationHandler();
        annoHandler.appendInitMethod(componentDef);
        annoHandler.appendDestroyMethod(componentDef);
        annoHandler.appendAspect(componentDef);
        annoHandler.appendInterType(componentDef);
        String expression = null;
        if (body != null) {
            expression = body.trim();
            if (!LdiStringUtil.isEmpty(expression)) {
                componentDef.setExpression(this.createExpression(context, expression));
            } else {
                expression = null;
            }
        }
        if (componentDef.getComponentClass() == null && !InstanceDefFactory.OUTER.equals(componentDef.getInstanceDef()) && expression == null) {
            throw new TagAttributeNotDefinedRuntimeException("component", "class");
        }
        if (context.peek() instanceof LaContainer) {
            LaContainer container = (LaContainer)context.peek();
            if (componentDef.getComponentName() != null) {
                RedefinableXmlLaContainerBuilder builder;
                String basePath = (String)context.getParameter("originalPath");
                LaContainer redefined = this.redefine(componentDef, basePath, builder = (RedefinableXmlLaContainerBuilder)context.getParameter("builder"));
                if (redefined != null) {
                    LaContainerBuilderUtils.mergeContainer(container, redefined);
                } else {
                    container.register(componentDef);
                }
            } else {
                container.register(componentDef);
            }
        } else {
            ArgDef argDef = (ArgDef)context.peek();
            argDef.setChildComponentDef(componentDef);
        }
    }

    protected LaContainer redefine(ComponentDef componentDef, String path, RedefinableXmlLaContainerBuilder builder) {
        int delimiter = path.lastIndexOf("+");
        int slash = path.lastIndexOf(47);
        if (delimiter >= 0 && delimiter > slash) {
            return null;
        }
        String name = componentDef.getComponentName();
        String[] diconPaths = this.constructRedifinitionDiconPaths(path, name);
        String diconPath = null;
        for (int i = 0; i < diconPaths.length; ++i) {
            if (!LaContainerBuilderUtils.resourceExists(diconPaths[i], builder)) continue;
            diconPath = diconPaths[i];
            break;
        }
        if (diconPath == null) {
            return null;
        }
        return LaContainerFactory.create(diconPath);
    }

    protected String[] constructRedifinitionDiconPaths(String path, String name) {
        String suffix;
        String body;
        ArrayList<String> pathList = new ArrayList<String>();
        int dot = path.lastIndexOf(46);
        if (dot < 0) {
            body = path;
            suffix = "";
        } else {
            body = path.substring(0, dot);
            suffix = path.substring(dot);
        }
        String resourcePath = LaContainerBuilderUtils.fromURLToResourcePath(body + "+" + name + suffix);
        if (resourcePath != null) {
            pathList.add(resourcePath);
        }
        pathList.add(body + "+" + name + suffix);
        return pathList.toArray(new String[0]);
    }
}

