/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.redefiner.util;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;

public class CompositeClassLoader
extends ClassLoader {
    private final ClassLoader[] classLoaders;

    public CompositeClassLoader(ClassLoader[] classLoaders) {
        super(CompositeClassLoader.getSystemClassLoader().getParent());
        this.classLoaders = this.normalizeClassLoaders(classLoaders);
    }

    public CompositeClassLoader(ClassLoader[] classLoaders, ClassLoader parent) {
        super(parent);
        this.classLoaders = this.normalizeClassLoaders(classLoaders);
    }

    protected ClassLoader[] normalizeClassLoaders(ClassLoader[] classLoaders) {
        LinkedHashSet<ClassLoader> set = new LinkedHashSet<ClassLoader>();
        for (int i = 0; i < classLoaders.length; ++i) {
            if (set.contains(classLoaders[i])) continue;
            set.add(classLoaders[i]);
        }
        return set.toArray(new ClassLoader[0]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("C{ ");
        for (int i = 0; i < this.classLoaders.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.classLoaders[i]);
        }
        sb.append(" }(parent=");
        sb.append(this.getParent());
        sb.append(")");
        return sb.toString();
    }

    @Override
    public URL getResource(String name) {
        for (int i = 0; i < this.classLoaders.length; ++i) {
            URL url = this.classLoaders[i].getResource(name);
            if (url == null) continue;
            return url;
        }
        if (this.getParent() != null) {
            return super.getResource(name);
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        LinkedHashSet<URL> set = new LinkedHashSet<URL>();
        for (int i = 0; i < this.classLoaders.length; ++i) {
            Enumeration<URL> enm = this.classLoaders[i].getResources(name);
            while (enm.hasMoreElements()) {
                set.add(enm.nextElement());
            }
        }
        if (this.getParent() != null) {
            Enumeration<URL> enm = super.getResources(name);
            while (enm.hasMoreElements()) {
                set.add(enm.nextElement());
            }
        }
        return Collections.enumeration(set);
    }

    @Override
    public synchronized Class<?> loadClass(String name) throws ClassNotFoundException {
        for (int i = 0; i < this.classLoaders.length; ++i) {
            try {
                return this.classLoaders[i].loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
        }
        if (this.getParent() != null) {
            return super.loadClass(name);
        }
        throw new ClassNotFoundException("Class doesn't exist: " + name);
    }
}

