/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.tx.adapter;

import javax.transaction.Status;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.lastaflute.di.exception.SIllegalStateException;
import org.lastaflute.di.helper.log.LaLogger;
import org.lastaflute.di.tx.TransactionCallback;
import org.lastaflute.di.tx.TransactionManagerAdapter;

public class JTAUserTransactionAdapter
implements TransactionManagerAdapter,
Status {
    private static final LaLogger logger = LaLogger.getLogger(JTAUserTransactionAdapter.class);
    protected final UserTransaction userTransaction;

    public JTAUserTransactionAdapter(UserTransaction userTransaction) {
        this.userTransaction = userTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object required(TransactionCallback callback) throws Throwable {
        boolean began = this.begin();
        try {
            Object object = callback.execute(this);
            return object;
        }
        finally {
            if (began) {
                this.end();
            }
        }
    }

    @Override
    public Object requiresNew(TransactionCallback callback) throws Throwable {
        throw new UnsupportedOperationException("REQUIRES_NEW");
    }

    @Override
    public Object mandatory(TransactionCallback callback) throws Throwable {
        if (!this.hasTransaction()) {
            throw new SIllegalStateException("ESSR0311", null);
        }
        return callback.execute(this);
    }

    @Override
    public Object notSupported(TransactionCallback callback) throws Throwable {
        throw new UnsupportedOperationException("NOT_SUPPORTED");
    }

    @Override
    public Object never(TransactionCallback callback) throws Throwable {
        if (this.hasTransaction()) {
            throw new SIllegalStateException("ESSR0317", null);
        }
        return callback.execute(this);
    }

    @Override
    public void setRollbackOnly() {
        try {
            if (this.userTransaction.getStatus() == 0) {
                this.userTransaction.setRollbackOnly();
            }
        }
        catch (Exception e) {
            logger.log("ESSR0017", new Object[]{e.getMessage()}, e);
        }
    }

    protected boolean hasTransaction() throws SystemException {
        int status = this.userTransaction.getStatus();
        return status != 6 && status != 5;
    }

    protected boolean begin() throws Exception {
        if (this.hasTransaction()) {
            return false;
        }
        this.userTransaction.begin();
        return true;
    }

    protected void end() throws Exception {
        if (this.userTransaction.getStatus() == 0) {
            this.userTransaction.commit();
        } else {
            this.userTransaction.rollback();
        }
    }
}

