/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.expression.dwarf;

import java.util.ArrayList;
import java.util.Map;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.expression.dwarf.ExpressionCastResolver;
import org.lastaflute.di.core.expression.dwarf.ExpressionPlainHook;
import org.lastaflute.di.helper.beans.BeanDesc;
import org.lastaflute.di.helper.beans.PropertyDesc;
import org.lastaflute.di.helper.beans.factory.BeanDescFactory;
import org.lastaflute.di.util.LdiClassUtil;
import org.lastaflute.di.util.LdiResourceUtil;
import org.lastaflute.di.util.LdiSrl;
import org.lastaflute.di.util.LdiStringUtil;

public class SimpleExpressionPlainHook
implements ExpressionPlainHook {
    protected static final ExpressionCastResolver castResolver = new ExpressionCastResolver();

    @Override
    public Object hookPlainly(String exp, Map<String, ? extends Object> contextMap, LaContainer container, Class<?> resultType) {
        Class<?> realType;
        String realExp;
        ExpressionCastResolver.CastResolved resolved = castResolver.resolveCast(exp, resultType);
        if (resolved != null) {
            realExp = resolved.getFilteredExp();
            realType = resolved.getResolvedType();
        } else {
            realExp = exp.trim();
            realType = resultType;
        }
        return this.doHookPlainly(realExp, contextMap, container, realType);
    }

    protected Object doHookPlainly(String exp, Map<String, ? extends Object> contextMap, LaContainer container, Class<?> resultType) {
        Object resovled = this.resolveSimpleString(exp, contextMap, container, resultType);
        if (resovled != null) {
            return resovled;
        }
        resovled = this.resolveSimpleNumber(exp, contextMap, container, resultType);
        if (resovled != null) {
            return resovled;
        }
        resovled = this.resolveSimpleEqualEqual(exp, contextMap, container, resultType);
        if (resovled != null) {
            return resovled;
        }
        resovled = this.resolveSimpleType(exp, contextMap, container, resultType);
        if (resovled != null) {
            return resovled;
        }
        resovled = this.resolveSimpleComponent(exp, contextMap, container, resultType);
        if (resovled != null) {
            return resovled;
        }
        resovled = this.resolveExistsResource(exp, contextMap, container, resultType);
        if (resovled != null) {
            return resovled;
        }
        resovled = this.resolveProviderConfig(exp, contextMap, container, resultType);
        if (resovled != null) {
            return resovled;
        }
        resovled = this.resolveComponentList(exp, contextMap, container, resultType);
        if (resovled != null) {
            return resovled;
        }
        return null;
    }

    protected Object resolveSimpleString(String exp, Map<String, ? extends Object> contextMap, LaContainer container, Class<?> resultType) {
        String unquoted;
        if (exp.startsWith("\"") && exp.endsWith("\"") && exp.length() > "\"".length() && !(unquoted = exp.substring("\"".length(), exp.length() - "\"".length())).contains("\"")) {
            return unquoted;
        }
        return null;
    }

    protected Object resolveSimpleNumber(String exp, Map<String, ? extends Object> contextMap, LaContainer container, Class<?> resultType) {
        if (LdiStringUtil.isNumber(exp)) {
            if (exp.length() > 9) {
                return Integer.valueOf(exp);
            }
            return Long.valueOf(exp);
        }
        return null;
    }

    protected Object resolveSimpleEqualEqual(String exp, Map<String, ? extends Object> contextMap, LaContainer container, Class<?> resultType) {
        String[] split;
        if (exp.contains("==") && (split = exp.split("==")).length == 2) {
            String left = split[0].trim();
            String right = split[1].trim();
            if (left.startsWith("'") && left.endsWith("'") && left.length() > "'".length() && right.startsWith("'") && right.endsWith("'") && right.length() > "'".length()) {
                String unquotedLeft = left.substring("'".length(), left.length() - "'".length());
                String unquotedRight = right.substring("'".length(), right.length() - "'".length());
                if (!unquotedLeft.contains("'") && !unquotedRight.contains("'")) {
                    return unquotedLeft.equals(unquotedRight);
                }
            }
        }
        return null;
    }

    protected Object resolveSimpleType(String exp, Map<String, ? extends Object> contextMap, LaContainer container, Class<?> resultType) {
        if (exp.startsWith("@") && exp.endsWith("@class")) {
            String className = exp.substring("@".length(), exp.lastIndexOf("@class"));
            return LdiClassUtil.forName(className);
        }
        return null;
    }

    protected Object resolveSimpleComponent(String exp, Map<String, ? extends Object> contextMap, LaContainer container, Class<?> resultType) {
        if (!LdiSrl.containsAny(exp, ".", ",", "'", "\"", "@", "#") && container.hasComponentDef(exp)) {
            return container.getComponent(exp);
        }
        return null;
    }

    protected Object resolveExistsResource(String exp, Map<String, ? extends Object> contextMap, LaContainer container, Class<?> resultType) {
        String path;
        if (exp.startsWith(EXISTS_BEGIN) && exp.endsWith("')") && !(path = exp.substring(EXISTS_BEGIN.length(), exp.lastIndexOf("')"))).contains("'")) {
            return LdiResourceUtil.exists(path);
        }
        return null;
    }

    protected Object resolveProviderConfig(String exp, Map<String, ? extends Object> contextMap, LaContainer container, Class<?> resultType) {
        String[] tokens;
        if (exp.startsWith("provider.config().get") && exp.endsWith("()") && exp.contains(".") && !exp.contains("\"") && (tokens = exp.split("\\.")).length > 1) {
            Object component = null;
            BeanDesc beanDesc = null;
            for (String prop : tokens) {
                if (prop.endsWith("()")) {
                    if (component == null) break;
                    String methodName = prop.substring(0, prop.length() - "()".length());
                    component = beanDesc.invoke(component, methodName, null);
                    beanDesc = BeanDescFactory.getBeanDesc(component.getClass());
                    continue;
                }
                if (beanDesc == null) {
                    if (!container.hasComponentDef(prop)) break;
                    component = container.getComponent(prop);
                    beanDesc = BeanDescFactory.getBeanDesc(component.getClass());
                    continue;
                }
                PropertyDesc propertyDesc = beanDesc.getPropertyDesc(prop);
                if (propertyDesc == null) break;
                component = propertyDesc.getValue(component);
                beanDesc = BeanDescFactory.getBeanDesc(component.getClass());
            }
            if (component != null) {
                return component;
            }
        }
        return null;
    }

    protected Object resolveComponentList(String exp, Map<String, ? extends Object> contextMap, LaContainer container, Class<?> resultType) {
        if (!exp.contains("\"") && !exp.contains("'") && exp.startsWith("[") && exp.endsWith("]")) {
            String listContents = exp.substring(1, exp.length() - 1);
            String[] elements = LdiStringUtil.split(listContents, ",");
            boolean compAry = false;
            for (String comp : elements) {
                if (LdiStringUtil.isNumber(comp)) continue;
                compAry = true;
                break;
            }
            if (compAry) {
                ArrayList<Object> resultList = new ArrayList<Object>();
                for (String comp : elements) {
                    Object component = container.getComponent(comp.trim());
                    resultList.add(component);
                }
                return castResolver.convertListTo(exp, contextMap, container, resultType, resultList);
            }
        }
        return null;
    }
}

