/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.util;

import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.factory.LaContainerFactory;
import org.lastaflute.di.core.factory.provider.LaContainerProvider;
import org.lastaflute.di.core.meta.impl.LaContainerBehavior;
import org.lastaflute.di.core.smart.cool.LaContainerFactoryCoolProvider;
import org.lastaflute.di.core.smart.hot.HotdeployUtil;
import org.lastaflute.di.core.smart.warm.WarmdeployBehavior;
import org.lastaflute.di.helper.beans.BeanDesc;
import org.lastaflute.di.helper.beans.factory.BeanDescFactory;
import org.lastaflute.di.util.LdiFieldUtil;

public class SmartDeployUtil {
    protected SmartDeployUtil() {
    }

    public static boolean isSmartdeployMode(LaContainer container) {
        return SmartDeployUtil.isHotdeployMode(container) || SmartDeployUtil.isCooldeployMode(container) || SmartDeployUtil.isWarmdeployMode(container);
    }

    public static boolean isHotdeployMode(LaContainer container) {
        return HotdeployUtil.isHotdeploy();
    }

    public static boolean isCooldeployMode(LaContainer container) {
        BeanDesc bd = BeanDescFactory.getBeanDesc(LaContainerFactory.class);
        LaContainerProvider provider = (LaContainerProvider)LdiFieldUtil.get(bd.getField("provider"), null);
        return provider instanceof LaContainerFactoryCoolProvider;
    }

    public static boolean isWarmdeployMode(LaContainer container) {
        LaContainerBehavior.Provider provider = LaContainerBehavior.getProvider();
        return provider instanceof WarmdeployBehavior;
    }

    public static String getDeployMode(LaContainer container) {
        if (SmartDeployUtil.isHotdeployMode(container)) {
            return "Hot Deploy";
        }
        if (SmartDeployUtil.isCooldeployMode(container)) {
            return "Cool Deploy";
        }
        if (SmartDeployUtil.isWarmdeployMode(container)) {
            return "Warm Deploy";
        }
        return "Normal Mode";
    }
}

