/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.lastaflute.di.exception.ParseRuntimeException;
import org.lastaflute.di.util.LdiStringUtil;

public class LdiDateConversionUtil {
    protected LdiDateConversionUtil() {
    }

    public static Date toDate(Object o) {
        return LdiDateConversionUtil.toDate(o, null);
    }

    public static Date toDate(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return LdiDateConversionUtil.toDate((String)o, pattern);
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof Calendar) {
            return ((Calendar)o).getTime();
        }
        return LdiDateConversionUtil.toDate(o.toString(), pattern);
    }

    public static Date toDate(String s, String pattern) {
        return LdiDateConversionUtil.toDate(s, pattern, Locale.getDefault());
    }

    public static Date toDate(String s, String pattern, Locale locale) {
        if (LdiStringUtil.isEmpty(s)) {
            return null;
        }
        SimpleDateFormat sdf = LdiDateConversionUtil.getDateFormat(s, pattern, locale);
        try {
            return sdf.parse(s);
        }
        catch (ParseException ex) {
            throw new ParseRuntimeException(ex);
        }
    }

    public static SimpleDateFormat getDateFormat(String s, String pattern, Locale locale) {
        if (pattern != null) {
            return new SimpleDateFormat(pattern);
        }
        return LdiDateConversionUtil.getDateFormat(s, locale);
    }

    public static SimpleDateFormat getDateFormat(String s, Locale locale) {
        String pattern = LdiDateConversionUtil.getPattern(locale);
        String shortPattern = LdiDateConversionUtil.removeDelimiter(pattern);
        String delimitor = LdiDateConversionUtil.findDelimiter(s);
        if (delimitor == null) {
            if (s.length() == shortPattern.length()) {
                return new SimpleDateFormat(shortPattern);
            }
            if (s.length() == shortPattern.length() + 2) {
                return new SimpleDateFormat(LdiStringUtil.replace(shortPattern, "yy", "yyyy"));
            }
        } else {
            String[] array = LdiStringUtil.split(s, delimitor);
            for (int i = 0; i < array.length; ++i) {
                if (array[i].length() != 4) continue;
                pattern = LdiStringUtil.replace(pattern, "yy", "yyyy");
                break;
            }
            return new SimpleDateFormat(pattern);
        }
        return new SimpleDateFormat();
    }

    public static SimpleDateFormat getDateFormat(Locale locale) {
        return new SimpleDateFormat(LdiDateConversionUtil.getPattern(locale));
    }

    public static SimpleDateFormat getY4DateFormat(Locale locale) {
        return new SimpleDateFormat(LdiDateConversionUtil.getY4Pattern(locale));
    }

    public static String getY4Pattern(Locale locale) {
        String pattern = LdiDateConversionUtil.getPattern(locale);
        if (pattern.indexOf("yyyy") < 0) {
            pattern = LdiStringUtil.replace(pattern, "yy", "yyyy");
        }
        return pattern;
    }

    public static String getPattern(Locale locale) {
        SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance(3, locale);
        String pattern = df.toPattern();
        int index = pattern.indexOf(32);
        if (index > 0) {
            pattern = pattern.substring(0, index);
        }
        if (pattern.indexOf("MM") < 0) {
            pattern = LdiStringUtil.replace(pattern, "M", "MM");
        }
        if (pattern.indexOf("dd") < 0) {
            pattern = LdiStringUtil.replace(pattern, "d", "dd");
        }
        return pattern;
    }

    public static String findDelimiter(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isDigit(c)) continue;
            return Character.toString(c);
        }
        return null;
    }

    public static String findDelimiterFromPattern(String pattern) {
        String ret = null;
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == 'y' || c == 'M' || c == 'd') continue;
            ret = String.valueOf(c);
            break;
        }
        return ret;
    }

    public static String removeDelimiter(String pattern) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c != 'y' && c != 'M' && c != 'd') continue;
            buf.append(c);
        }
        return buf.toString();
    }
}

