/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.helper.log;

import java.util.HashMap;
import java.util.Map;
import org.lastaflute.di.helper.message.MessageFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaLogger {
    private static final Logger log = LoggerFactory.getLogger(LaLogger.class);
    private static final Map<Class<?>, LaLogger> loggers = new HashMap();
    private static boolean initialized;

    public static synchronized LaLogger getLogger(Class<?> clazz) {
        LaLogger logger;
        if (!initialized) {
            LaLogger.initialize();
        }
        if ((logger = loggers.get(clazz)) == null) {
            logger = new LaLogger();
            loggers.put(clazz, logger);
        }
        return logger;
    }

    public static synchronized void initialize() {
        initialized = true;
    }

    public static synchronized void dispose() {
        loggers.clear();
        initialized = false;
    }

    public final boolean isDebugEnabled() {
        return log.isDebugEnabled();
    }

    public final void debug(Object message, Throwable throwable) {
        if (this.isDebugEnabled()) {
            log.debug(message != null ? message.toString() : null, throwable);
        }
    }

    public final void debug(Object message) {
        if (this.isDebugEnabled()) {
            log.debug(message != null ? message.toString() : null);
        }
    }

    public final boolean isInfoEnabled() {
        return log.isInfoEnabled();
    }

    public final void info(Object message, Throwable throwable) {
        if (this.isInfoEnabled()) {
            log.info(message != null ? message.toString() : null, throwable);
        }
    }

    public final void info(Object message) {
        if (this.isInfoEnabled()) {
            log.info(message != null ? message.toString() : null);
        }
    }

    public final void warn(Object message, Throwable throwable) {
        log.warn(message != null ? message.toString() : null, throwable);
    }

    public final void warn(Object message) {
        log.warn(message != null ? message.toString() : null);
    }

    public final void error(Object message, Throwable throwable) {
        log.error(message != null ? message.toString() : null, throwable);
    }

    public final void error(Object message) {
        log.error(message != null ? message.toString() : null);
    }

    public final void log(Throwable throwable) {
        this.error(throwable.getMessage(), throwable);
    }

    public final void log(String messageCode, Object[] args) {
        this.log(messageCode, args, null);
    }

    public final void log(String messageCode, Object[] args, Throwable throwable) {
        char messageType = messageCode.charAt(0);
        if (this.isEnabledFor(messageType)) {
            String message = MessageFormatter.getSimpleMessage(messageCode, args);
            switch (messageType) {
                case 'D': {
                    log.debug(message, throwable);
                    break;
                }
                case 'I': {
                    log.info(message, throwable);
                    break;
                }
                case 'W': {
                    log.warn(message, throwable);
                    break;
                }
                case 'E': {
                    log.error(message, throwable);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(messageType));
                }
            }
        }
    }

    private boolean isEnabledFor(char messageType) {
        switch (messageType) {
            case 'D': {
                return log.isDebugEnabled();
            }
            case 'I': {
                return log.isInfoEnabled();
            }
            case 'W': {
                return log.isWarnEnabled();
            }
            case 'E': {
                return log.isErrorEnabled();
            }
        }
        throw new IllegalArgumentException(String.valueOf(messageType));
    }
}

