/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import org.lastaflute.di.exception.ClassNotFoundRuntimeException;
import org.lastaflute.di.exception.IORuntimeException;
import org.lastaflute.di.util.EnumerationIterator;
import org.lastaflute.di.util.LdiClassUtil;
import org.lastaflute.di.util.LdiMethodUtil;

public abstract class LdiClassLoaderUtil {
    private static final Method findLoadedClassMethod = LdiClassLoaderUtil.getFindLoadedClassMethod();
    private static final Method defineClassMethod = LdiClassLoaderUtil.getDefineClassMethod();
    private static final Method definePackageMethod = LdiClassLoaderUtil.getDefinePackageMethod();

    protected LdiClassLoaderUtil() {
    }

    private static Method getFindLoadedClassMethod() {
        Method method = LdiClassUtil.getDeclaredMethod(ClassLoader.class, "findLoadedClass", new Class[]{String.class});
        method.setAccessible(true);
        return method;
    }

    private static Method getDefineClassMethod() {
        Method method = LdiClassUtil.getDeclaredMethod(ClassLoader.class, "defineClass", new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE});
        method.setAccessible(true);
        return method;
    }

    private static Method getDefinePackageMethod() {
        Method method = LdiClassUtil.getDeclaredMethod(ClassLoader.class, "definePackage", new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, URL.class});
        method.setAccessible(true);
        return method;
    }

    public static ClassLoader getClassLoader(Class<?> targetClass) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            return contextClassLoader;
        }
        ClassLoader targetClassLoader = targetClass.getClassLoader();
        ClassLoader thisClassLoader = LdiClassLoaderUtil.class.getClassLoader();
        if (targetClassLoader != null && thisClassLoader != null) {
            if (LdiClassLoaderUtil.isAncestor(thisClassLoader, targetClassLoader)) {
                return thisClassLoader;
            }
            return targetClassLoader;
        }
        if (targetClassLoader != null) {
            return targetClassLoader;
        }
        if (thisClassLoader != null) {
            return thisClassLoader;
        }
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        if (systemClassLoader != null) {
            return systemClassLoader;
        }
        throw new IllegalStateException("Not found the class loader: " + targetClass);
    }

    public static Iterator<URL> getResources(String name) {
        return LdiClassLoaderUtil.getResources(Thread.currentThread().getContextClassLoader(), name);
    }

    public static Iterator<URL> getResources(Class<?> targetClass, String name) {
        return LdiClassLoaderUtil.getResources(LdiClassLoaderUtil.getClassLoader(targetClass), name);
    }

    public static Iterator<URL> getResources(ClassLoader loader, String name) {
        try {
            Enumeration<URL> e = loader.getResources(name);
            return new EnumerationIterator<URL>(e);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    protected static boolean isAncestor(ClassLoader cl, ClassLoader other) {
        while (cl != null) {
            if (cl == other) {
                return true;
            }
            cl = cl.getParent();
        }
        return false;
    }

    public static Class<?> findLoadedClass(ClassLoader classLoader, String className) {
        for (ClassLoader loader = classLoader; loader != null; loader = loader.getParent()) {
            Class clazz = (Class)LdiMethodUtil.invoke(findLoadedClassMethod, loader, new Object[]{className});
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    public static Class<?> defineClass(ClassLoader classLoader, String className, byte[] bytes, int offset, int length) {
        return (Class)LdiMethodUtil.invoke(defineClassMethod, classLoader, new Object[]{className, bytes, new Integer(offset), new Integer(length)});
    }

    public static Package definePackage(ClassLoader classLoader, String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) {
        return (Package)LdiMethodUtil.invoke(definePackageMethod, classLoader, new Object[]{name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase});
    }

    public static Class<?> loadClass(ClassLoader loader, String className) {
        try {
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundRuntimeException(e);
        }
    }
}

