/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.lastaflute.di.util.LdiDecimalFormatUtil;
import org.lastaflute.di.util.LdiStringUtil;

public class LdiIntegerConversionUtil {
    protected LdiIntegerConversionUtil() {
    }

    public static Integer toInteger(Object o) {
        return LdiIntegerConversionUtil.toInteger(o, null);
    }

    public static Integer toInteger(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Number) {
            return new Integer(((Number)o).intValue());
        }
        if (o instanceof String) {
            return LdiIntegerConversionUtil.toInteger((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return new Integer(new SimpleDateFormat(pattern).format(o));
            }
            return new Integer((int)((Date)o).getTime());
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? new Integer(1) : new Integer(0);
        }
        return LdiIntegerConversionUtil.toInteger(o.toString());
    }

    private static Integer toInteger(String s) {
        if (LdiStringUtil.isEmpty(s)) {
            return null;
        }
        return new Integer(LdiDecimalFormatUtil.normalize(s));
    }

    public static int toPrimitiveInt(Object o) {
        return LdiIntegerConversionUtil.toPrimitiveInt(o, null);
    }

    public static int toPrimitiveInt(Object o, String pattern) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof String) {
            return LdiIntegerConversionUtil.toPrimitiveInt((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return Integer.parseInt(new SimpleDateFormat(pattern).format(o));
            }
            return (int)((Date)o).getTime();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1 : 0;
        }
        return LdiIntegerConversionUtil.toPrimitiveInt(o.toString());
    }

    private static int toPrimitiveInt(String s) {
        if (LdiStringUtil.isEmpty(s)) {
            return 0;
        }
        return Integer.parseInt(LdiDecimalFormatUtil.normalize(s));
    }
}

