/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.factory.dixml.taghandler;

import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.assembler.BindingTypeDefFactory;
import org.lastaflute.di.core.factory.dixml.exception.TagAttributeNotDefinedRuntimeException;
import org.lastaflute.di.core.factory.dixml.taghandler.AbstractTagHandler;
import org.lastaflute.di.core.meta.BindingTypeDef;
import org.lastaflute.di.core.meta.PropertyDef;
import org.lastaflute.di.core.meta.impl.PropertyDefImpl;
import org.lastaflute.di.helper.xml.TagHandlerContext;
import org.lastaflute.di.util.LdiStringUtil;
import org.xml.sax.Attributes;

public class PropertyTagHandler
extends AbstractTagHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void start(TagHandlerContext context, Attributes attributes) {
        String name = attributes.getValue("name");
        if (name == null) {
            throw new TagAttributeNotDefinedRuntimeException("property", "name");
        }
        PropertyDefImpl pd = this.createPropertyDef(name);
        String bindingTypeName = attributes.getValue("bindingType");
        if (bindingTypeName != null) {
            BindingTypeDef bindingTypeDef = BindingTypeDefFactory.getBindingTypeDef(bindingTypeName);
            pd.setBindingTypeDef(bindingTypeDef);
        }
        context.push(pd);
    }

    @Override
    public void end(TagHandlerContext context, String body) {
        PropertyDef propertyDef = (PropertyDef)context.pop();
        if (!LdiStringUtil.isEmpty(body)) {
            propertyDef.setExpression(this.createExpression(context, body));
        }
        ComponentDef componentDef = (ComponentDef)context.peek();
        componentDef.addPropertyDef(propertyDef);
    }

    protected PropertyDefImpl createPropertyDef(String name) {
        return new PropertyDefImpl(name);
    }
}

