/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.util;

import java.util.HashSet;
import java.util.Set;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.LaContainer;

public class Traversal {
    public static Object forEachComponent(LaContainer container, ComponentDefHandler handler) {
        return Traversal.forEachComponent(container, handler, true);
    }

    public static Object forEachComponent(LaContainer container, final ComponentDefHandler handler, boolean parentFirst) {
        return Traversal.forEachContainer(container, new S2ContainerHandler(){

            @Override
            public Object processContainer(LaContainer container) {
                for (int i = 0; i < container.getComponentDefSize(); ++i) {
                    Object result = handler.processComponent(container.getComponentDef(i));
                    if (result == null) continue;
                    return result;
                }
                return null;
            }
        }, parentFirst);
    }

    public static Object forEachContainer(LaContainer container, S2ContainerHandler handler) {
        return Traversal.forEachContainer(container, handler, true, new HashSet<LaContainer>());
    }

    public static Object forEachContainer(LaContainer container, S2ContainerHandler handler, boolean parentFirst) {
        return Traversal.forEachContainer(container, handler, parentFirst, new HashSet<LaContainer>());
    }

    protected static Object forEachContainer(LaContainer container, S2ContainerHandler handler, boolean parentFirst, Set<LaContainer> processed) {
        Object result;
        if (parentFirst && (result = handler.processContainer(container)) != null) {
            return result;
        }
        for (int i = 0; i < container.getChildSize(); ++i) {
            LaContainer child = container.getChild(i);
            if (processed.contains(child)) continue;
            processed.add(child);
            Object result2 = Traversal.forEachContainer(child, handler, parentFirst, processed);
            if (result2 == null) continue;
            return result2;
        }
        if (!parentFirst) {
            return handler.processContainer(container);
        }
        return null;
    }

    public static Object forEachParentContainer(LaContainer container, S2ContainerHandler handler) {
        return Traversal.forEachParentContainer(container, handler, true, new HashSet<LaContainer>());
    }

    public static Object forEachParentContainer(LaContainer container, S2ContainerHandler handler, boolean childFirst) {
        return Traversal.forEachParentContainer(container, handler, childFirst, new HashSet<LaContainer>());
    }

    protected static Object forEachParentContainer(LaContainer container, S2ContainerHandler handler, boolean childFirst, Set<LaContainer> processed) {
        Object result;
        if (childFirst && (result = handler.processContainer(container)) != null) {
            return result;
        }
        for (int i = 0; i < container.getParentSize(); ++i) {
            LaContainer parent = container.getParent(i);
            if (processed.contains(parent)) continue;
            processed.add(parent);
            Object result2 = Traversal.forEachParentContainer(parent, handler, childFirst, processed);
            if (result2 == null) continue;
            return result2;
        }
        if (!childFirst) {
            return handler.processContainer(container);
        }
        return null;
    }

    public static interface ComponentDefHandler {
        public Object processComponent(ComponentDef var1);
    }

    public static interface S2ContainerHandler {
        public Object processContainer(LaContainer var1);
    }
}

