/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.exception;

import java.sql.SQLException;
import org.lastaflute.di.helper.message.MessageFormatter;

public class SSQLException
extends SQLException {
    private static final long serialVersionUID = 4098267431221202677L;
    private String messageCode;
    private String sql;
    private Object[] args;

    public SSQLException(String messageCode, Object[] args) {
        this(messageCode, args, null, 0, null);
    }

    public SSQLException(String messageCode, Object[] args, Throwable cause) {
        this(messageCode, args, null, 0, cause);
    }

    public SSQLException(String messageCode, Object[] args, String sqlState) {
        this(messageCode, args, sqlState, 0, null);
    }

    public SSQLException(String messageCode, Object[] args, String sqlState, Throwable cause) {
        this(messageCode, args, sqlState, 0, cause);
    }

    public SSQLException(String messageCode, Object[] args, String sqlState, int vendorCode) {
        this(messageCode, args, sqlState, vendorCode, null);
    }

    public SSQLException(String messageCode, Object[] args, String sqlState, int vendorCode, Throwable cause) {
        this(messageCode, args, sqlState, vendorCode, cause, null);
    }

    public SSQLException(String messageCode, Object[] args, String sqlState, int vendorCode, Throwable cause, String sql) {
        super(MessageFormatter.getMessage(messageCode, args), sqlState, vendorCode);
        this.messageCode = messageCode;
        this.args = args;
        this.sql = sql;
        this.initCause(cause);
        if (cause instanceof SQLException) {
            this.setNextException((SQLException)cause);
        }
    }

    public String getMessageCode() {
        return this.messageCode;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public String getSql() {
        return this.sql;
    }
}

