/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.lastaflute.di.util.CaseInsensitiveMap;

public class CaseInsensitiveSet
extends AbstractSet<String>
implements Set<String>,
Serializable {
    static final long serialVersionUID = 0L;
    private static final Object PRESENT = new Object();
    private transient Map<String, Object> map;

    public CaseInsensitiveSet() {
        this.map = new CaseInsensitiveMap();
    }

    public CaseInsensitiveSet(Collection<String> c) {
        this.map = new CaseInsensitiveMap(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
    }

    public CaseInsensitiveSet(int initialCapacity) {
        this.map = new CaseInsensitiveMap(initialCapacity);
    }

    @Override
    public Iterator<String> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(String o) {
        return this.map.put(o, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

