/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.autoregister;

import java.io.File;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.lastaflute.di.core.autoregister.AbstractComponentAutoRegister;
import org.lastaflute.di.exception.ResourceNotFoundRuntimeException;
import org.lastaflute.di.util.ClassTraversal;
import org.lastaflute.di.util.LdiJarFileUtil;
import org.lastaflute.di.util.LdiResourceUtil;
import org.lastaflute.di.util.LdiStringUtil;

public abstract class AbstractJarComponentAutoRegister
extends AbstractComponentAutoRegister {
    private String baseDir;
    private Pattern[] jarFileNamePatterns;

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public void registerAll() {
        File dir;
        if (this.baseDir == null) {
            this.setupBaseDir();
        }
        if (!(dir = new File(this.baseDir)).exists() || !dir.isDirectory()) {
            throw new ResourceNotFoundRuntimeException(this.baseDir);
        }
        String[] jars = dir.list();
        for (int i = 0; i < jars.length; ++i) {
            if (!this.isAppliedJar(jars[i])) continue;
            JarFile jarFile = LdiJarFileUtil.create(this.findJar(jars[i]));
            ClassTraversal.forEach(jarFile, (ClassTraversal.ClassHandler)this);
        }
    }

    protected abstract void setupBaseDir();

    protected boolean isAppliedJar(String jarFileName) {
        if (this.jarFileNamePatterns == null) {
            return true;
        }
        String extention = LdiResourceUtil.getExtension(jarFileName);
        if (extention == null || !extention.equalsIgnoreCase("jar")) {
            return false;
        }
        String name = LdiResourceUtil.removeExtension(jarFileName);
        for (int i = 0; i < this.jarFileNamePatterns.length; ++i) {
            if (!this.jarFileNamePatterns[i].matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    protected File findJar(String jarFileName) {
        return new File(this.baseDir, jarFileName);
    }

    public void setJarFileNames(String jarFileNames) {
        String[] array = LdiStringUtil.split(jarFileNames, ",");
        this.jarFileNamePatterns = new Pattern[array.length];
        for (int i = 0; i < array.length; ++i) {
            String s = array[i].trim();
            this.jarFileNamePatterns[i] = Pattern.compile(s);
        }
    }
}

