/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.util;

import java.io.Externalizable;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.ContainerConstants;
import org.lastaflute.di.helper.log.LaLogger;
import org.lastaflute.di.util.LdiStringUtil;

public class ComponentUtil
implements ContainerConstants {
    private static final LaLogger logger = LaLogger.getLogger(ComponentUtil.class);
    private static final Class<?>[] EMPTY_CLASSES = new Class[0];
    private static final Set<Class<?>> notAssignableClasses = new HashSet();

    private ComponentUtil() {
    }

    public static Class<?>[] getAssignableClasses(Class<?> componentClass) {
        if (componentClass == null) {
            return EMPTY_CLASSES;
        }
        HashSet classes = new HashSet(4);
        for (Class<?> clazz = componentClass; clazz != Object.class && clazz != null; clazz = clazz.getSuperclass()) {
            ComponentUtil.addAssignableClasses(classes, clazz);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static void addAssignableClasses(Set<Class<?>> classes, Class<?> clazz) {
        if (notAssignableClasses.contains(clazz)) {
            return;
        }
        classes.add(clazz);
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            ComponentUtil.addAssignableClasses(classes, interfaces[i]);
        }
    }

    public static void putRegisterLog(ComponentDef cd) {
        if (logger.isDebugEnabled()) {
            String componentName;
            StringBuffer buf = new StringBuffer(100);
            Class<?> componentClass = cd.getComponentClass();
            if (componentClass != null) {
                buf.append(componentClass.getName());
            }
            if (!LdiStringUtil.isEmpty(componentName = cd.getComponentName())) {
                buf.append("[").append(componentName).append("]");
            }
            logger.log("DSSR0105", new Object[]{new String(buf)});
        }
    }

    static {
        notAssignableClasses.add(Cloneable.class);
        notAssignableClasses.add(Comparable.class);
        notAssignableClasses.add(Serializable.class);
        notAssignableClasses.add(Externalizable.class);
        notAssignableClasses.add(ContainerConstants.class);
    }
}

