/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.exception;

import java.sql.SQLException;
import org.lastaflute.di.exception.SRuntimeException;
import org.lastaflute.di.exception.SSQLException;
import org.lastaflute.di.helper.message.MessageFormatter;

public class SQLRuntimeException
extends SRuntimeException {
    private static final long serialVersionUID = 1L;

    public SQLRuntimeException(SQLException cause) {
        super("ESSR0072", new Object[]{SQLRuntimeException.getSql(cause), SQLRuntimeException.getRealMessage(cause), Integer.toString(cause.getErrorCode()), cause.getSQLState()}, cause);
    }

    protected static String getSql(SQLException cause) {
        if (cause instanceof SSQLException) {
            return ((SSQLException)cause).getSql();
        }
        return "";
    }

    protected static String getRealMessage(SQLException cause) {
        StringBuffer buf = new StringBuffer(256);
        buf.append(cause.getMessage()).append(" : [");
        for (SQLException next = cause.getNextException(); next != null; next = next.getNextException()) {
            buf.append(MessageFormatter.getSimpleMessage("ESSR0071", new Object[]{next.getMessage(), Integer.toString(next.getErrorCode()), next.getSQLState()})).append("], [");
        }
        for (Throwable t = cause.getCause(); t != null; t = t.getCause()) {
            buf.append(t.getMessage()).append("], [");
        }
        buf.setLength(buf.length() - 4);
        return new String(buf);
    }
}

