/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.lastaflute.di.util.LdiFileInputStreamUtil;
import org.lastaflute.di.util.LdiFileUtil;
import org.lastaflute.di.util.LdiInputStreamUtil;
import org.lastaflute.di.util.LdiJarFileUtil;
import org.lastaflute.di.util.LdiZipInputStreamUtil;

public class ResourceTraversal {
    protected ResourceTraversal() {
    }

    public static void forEach(File rootDir, ResourceHandler handler) {
        ResourceTraversal.forEach(rootDir, null, handler);
    }

    public static void forEach(File rootDir, String baseDirectory, ResourceHandler handler) {
        File baseDir = ResourceTraversal.getBaseDir(rootDir, baseDirectory);
        if (baseDir.exists()) {
            ResourceTraversal.traverseFileSystem(rootDir, baseDir, handler);
        }
    }

    public static void forEach(JarFile jarFile, ResourceHandler handler) {
        ResourceTraversal.forEach(jarFile, "", handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forEach(JarFile jarFile, String prefix, ResourceHandler handler) {
        int pos = prefix.length();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            String entryName;
            JarEntry entry = enumeration.nextElement();
            if (entry.isDirectory() || !(entryName = entry.getName().replace('\\', '/')).startsWith(prefix)) continue;
            InputStream is = LdiJarFileUtil.getInputStream(jarFile, entry);
            try {
                handler.processResource(entryName.substring(pos), is);
            }
            finally {
                LdiInputStreamUtil.close(is);
            }
        }
    }

    public static void forEach(ZipInputStream zipInputStream, ResourceHandler handler) {
        ResourceTraversal.forEach(zipInputStream, "", handler);
    }

    public static void forEach(final ZipInputStream zipInputStream, String prefix, ResourceHandler handler) {
        int pos = prefix.length();
        ZipEntry entry = null;
        while ((entry = LdiZipInputStreamUtil.getNextEntry(zipInputStream)) != null) {
            String entryName;
            if (entry.isDirectory() || !(entryName = entry.getName().replace('\\', '/')).startsWith(prefix)) continue;
            handler.processResource(entryName.substring(pos), new FilterInputStream(zipInputStream){

                @Override
                public void close() throws IOException {
                    LdiZipInputStreamUtil.closeEntry(zipInputStream);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void traverseFileSystem(File rootDir, File baseDir, ResourceHandler handler) {
        File[] files = baseDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                ResourceTraversal.traverseFileSystem(rootDir, file, handler);
                continue;
            }
            int pos = LdiFileUtil.getCanonicalPath(rootDir).length();
            String filePath = LdiFileUtil.getCanonicalPath(file);
            String resourcePath = filePath.substring(pos + 1).replace('\\', '/');
            FileInputStream is = LdiFileInputStreamUtil.create(file);
            try {
                handler.processResource(resourcePath, is);
                continue;
            }
            finally {
                LdiInputStreamUtil.close(is);
            }
        }
    }

    private static File getBaseDir(File rootDir, String baseDirectory) {
        File baseDir = rootDir;
        if (baseDirectory != null) {
            String[] names = baseDirectory.split("/");
            for (int i = 0; i < names.length; ++i) {
                baseDir = new File(baseDir, names[i]);
            }
        }
        return baseDir;
    }

    public static interface ResourceHandler {
        public void processResource(String var1, InputStream var2);
    }
}

