/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.deployer;

import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.deployer.AbstractComponentDeployer;
import org.lastaflute.di.core.exception.CyclicReferenceRuntimeException;

public class SingletonComponentDeployer
extends AbstractComponentDeployer {
    private Object component;
    private boolean instantiating = false;

    public SingletonComponentDeployer(ComponentDef componentDef) {
        super(componentDef);
    }

    @Override
    public void init() {
        this.deploy();
    }

    @Override
    public Object deploy() {
        if (this.component == null) {
            this.assemble();
        }
        return this.component;
    }

    private void assemble() {
        if (this.instantiating) {
            throw new CyclicReferenceRuntimeException(this.getComponentDef().getComponentClass());
        }
        this.instantiating = true;
        try {
            this.component = this.getConstructorAssembler().assemble();
        }
        finally {
            this.instantiating = false;
        }
        this.getPropertyAssembler().assemble(this.component);
        this.getInitMethodAssembler().assemble(this.component);
    }

    @Override
    public void injectDependency(Object component) {
        throw new UnsupportedOperationException("injectDependency");
    }

    @Override
    public void destroy() {
        if (this.component == null) {
            return;
        }
        this.getDestroyMethodAssembler().assemble(this.component);
        this.component = null;
    }
}

