/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.meta.impl;

import java.util.HashMap;
import java.util.Map;
import org.lastaflute.di.core.exception.IllegalInstanceDefRuntimeException;
import org.lastaflute.di.core.meta.InstanceDef;
import org.lastaflute.di.core.meta.impl.InstanceApplicationDef;
import org.lastaflute.di.core.meta.impl.InstanceOuterDef;
import org.lastaflute.di.core.meta.impl.InstancePrototypeDef;
import org.lastaflute.di.core.meta.impl.InstanceRequestDef;
import org.lastaflute.di.core.meta.impl.InstanceSessionDef;
import org.lastaflute.di.core.meta.impl.InstanceSingletonDef;

public class InstanceDefFactory {
    public static final InstanceDef SINGLETON = new InstanceSingletonDef("singleton");
    public static final InstanceDef PROTOTYPE = new InstancePrototypeDef("prototype");
    public static final InstanceDef APPLICATION = new InstanceApplicationDef("application");
    public static final InstanceDef SESSION = new InstanceSessionDef("session");
    public static final InstanceDef REQUEST = new InstanceRequestDef("request");
    public static final InstanceDef OUTER = new InstanceOuterDef("outer");
    private static Map<String, InstanceDef> instanceDefs = new HashMap<String, InstanceDef>();

    protected InstanceDefFactory() {
    }

    public static void addInstanceDef(InstanceDef instanceDef) {
        instanceDefs.put(instanceDef.getName(), instanceDef);
    }

    public static boolean existInstanceDef(String name) {
        return instanceDefs.containsKey(name);
    }

    public static InstanceDef getInstanceDef(String name) {
        if (!instanceDefs.containsKey(name)) {
            throw new IllegalInstanceDefRuntimeException(name);
        }
        return instanceDefs.get(name);
    }

    static {
        InstanceDefFactory.addInstanceDef(SINGLETON);
        InstanceDefFactory.addInstanceDef(PROTOTYPE);
        InstanceDefFactory.addInstanceDef(APPLICATION);
        InstanceDefFactory.addInstanceDef(SESSION);
        InstanceDefFactory.addInstanceDef(REQUEST);
        InstanceDefFactory.addInstanceDef(OUTER);
    }
}

